function mpc = Transmission_Network_PT_2030_Active_Economy

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1	2	0.000	0.000	0	0	1	1.0483	14.52	400	1	1.05	0.95	;
	2	2	0.000	0.000	0	0	1	1.0482	15.7	400	1	1.05	0.95	;
	3	2	0.000	0.000	0	0	1	1.042	6.23	400	1	1.05	0.95	;
	4	2	0.000	0.000	0	0	1	1.0373	1.03	400	1	1.05	0.95	;
	5	2	0.000	0.000	0	0	1	1.0486	17.44	220	1	1.05	0.95	;
	6	2	0.000	0.000	0	0	1	1.0482	17.37	220	1	1.05	0.95	;
	7	2	0.000	0.000	0	0	1	1.0329	-4.86	400	1	1.05	0.95	;
	305	2	0.000	0.000	0	0	1	1.0457	12.2	400	1	1.05	0.95	;
	8	1	0.000	0.000	0	0	1	1.0089	-0.84	150	2	1.05	0.95	;
	9	1	0.000	0.000	0	0	1	1.0314	-5.77	150	2	1.05	0.95	;
	10	2	0.000	0.000	0	0	1	1.0374	-4.91	150	2	1.05	0.95	;
	11	1	4.345	-0.326	0	0	1	1.0218	-7.01	150	2	1.05	0.95	;
	12	1	0.000	0.000	0	0	1	1.021	-8.65	150	2	1.05	0.95	;
	13	1	6.518	2.281	0	0	1	1.0293	-6.16	150	2	1.05	0.95	;
	14	2	0.000	0.000	0	0	1	1.0327	-5.61	150	2	1.05	0.95	;
	15	1	0.000	0.000	0	0	1	1.0372	-4.68	150	2	1.05	0.95	;
	16	1	0.000	0.000	0	0	1	1.0227	10.86	150	2	1.05	0.95	;
	17	1	0.000	0.000	0	0	1	1.0266	10.52	150	2	1.05	0.95	;
	18	1	7.604	-0.978	0	0	1	1.0288	10.96	150	2	1.05	0.95	;
	19	1	0.000	0.000	0	0	1	1.022	-7.24	150	2	1.05	0.95	;
	20	1	0.000	0.000	0	0	1	1.0265	-6.51	150	2	1.05	0.95	;
	21	1	0.000	0.000	0	0	1	1.0276	10.32	150	2	1.05	0.95	;
	22	2	0.000	0.000	0	0	1	1.0301	-6.61	150	2	1.05	0.95	;
	23	1	0.000	0.000	0	0	1	1.0148	-9.17	150	2	1.05	0.95	;
	24	2	0.000	0.000	0	0	1	1.0233	7.71	150	2	1.05	0.95	;
	25	1	0.000	0.000	0	0	1	1.0221	10.42	150	2	1.05	0.95	;
	26	1	4.345	0.109	0	0	1	1.0376	-4.87	150	2	1.05	0.95	;
	27	1	3.259	-0.217	0	0	1	1.0356	-5.29	150	2	1.05	0.95	;
	28	1	2.173	-0.217	0	0	1	1.0315	-6.64	150	2	1.05	0.95	;
	29	2	0.000	0.000	0	0	1	1.0271	-7.67	150	2	1.05	0.95	;
	30	2	0.000	0.000	0	0	1	1.0354	12.1	150	2	1.05	0.95	;
	31	1	0.000	0.000	0	0	1	1.0199	7.77	150	2	1.05	0.95	;
	32	1	0.000	0.000	0	0	1	1.0303	11.29	150	2	1.05	0.95	;
	33	1	0.000	0.000	0	0	1	1.0383	13.33	150	2	1.05	0.95	;
	34	2	0.000	0.000	0	-75	1	1.0318	-6.98	150	2	1.05	0.95	;
	36	1	0.000	0.000	0	0	1	1.0216	-0.71	220	2	1.05	0.95	;
	37	1	0.000	0.000	0	0	1	1.0259	-3.75	220	2	1.05	0.95	;
	38	1	0.000	0.000	0	0	1	1.0241	6.5	220	2	1.05	0.95	;
	39	1	0.000	0.000	0	0	1	1.0291	3.35	220	2	1.05	0.95	;
	40	1	0.000	0.000	0	0	1	1.047	15.94	220	2	1.05	0.95	;
	41	1	0.000	0.000	0	0	1	1.0246	6.55	220	2	1.05	0.95	;
	42	1	0.000	0.000	0	0	1	1.0317	6.58	220	2	1.05	0.95	;
	43	1	0.000	0.000	0	0	1	1.0242	-4.08	220	2	1.05	0.95	;
	44	1	0.000	0.000	0	0	1	1.024	6.18	220	2	1.05	0.95	;
	45	1	0.000	0.000	0	0	1	1.0276	-0.92	220	2	1.05	0.95	;
	46	1	0.000	0.000	0	0	1	1.0256	-2.42	220	2	1.05	0.95	;
	47	1	0.000	0.000	0	0	1	1.0302	8.21	220	2	1.05	0.95	;
	48	1	43.450	8.690	0	0	1	1.0264	5.34	220	2	1.05	0.95	;
	49	1	0.000	0.000	0	0	1	1.0213	6.35	220	2	1.05	0.95	;
	50	1	0.000	0.000	0	100	1	1.0261	-3.5	220	2	1.05	0.95	;
	51	1	0.000	0.000	0	0	1	1.0377	12.63	220	2	1.05	0.95	;
	52	1	0.000	0.000	0	0	1	1.0284	1.53	220	2	1.05	0.95	;
	53	1	0.000	0.000	0	0	1	1.0236	6.34	220	2	1.05	0.95	;
	54	1	0.000	0.000	0	0	1	1.0467	22.63	220	2	1.05	0.95	;
	55	1	0.000	0.000	0	0	1	1.0237	-4.2	220	2	1.05	0.95	;
	56	1	0.000	0.000	0	100	1	1.0254	-4.53	220	2	1.05	0.95	;
	57	1	0.000	0.000	0	0	1	1.025	6.9	220	2	1.05	0.95	;
	58	1	0.000	0.000	0	0	1	1.0234	-4.27	220	2	1.05	0.95	;
	59	1	0.000	0.000	0	0	1	1.0261	-3.89	220	2	1.05	0.95	;
	60	1	0.000	0.000	0	0	1	1.0316	8.31	220	2	1.05	0.95	;
	61	2	0.000	0.000	0	0	1	1.0307	8.32	220	2	1.05	0.95	;
	62	1	0.000	0.000	0	0	1	1.0322	8.53	220	2	1.05	0.95	;
	63	1	0.000	0.000	0	0	1	1.0442	20.57	220	2	1.05	0.95	;
	64	2	0.000	0.000	0	0	1	1.0219	-2.25	220	2	1.05	0.95	;
	65	2	0.000	0.000	0	0	1	1.0368	9.37	220	2	1.05	0.95	;
	66	1	0.000	0.000	0	0	1	1.0328	8.92	220	2	1.05	0.95	;
	67	1	2.173	-0.217	0	0	1	1.0266	7.2	220	2	1.05	0.95	;
	68	1	0.000	0.000	0	0	1	1.0234	6.37	220	2	1.05	0.95	;
	69	1	0.000	0.000	0	0	1	1.0285	5.17	220	2	1.05	0.95	;
	71	1	0.000	0.000	0	0	1	1.028	2.5	220	2	1.05	0.95	;
	72	1	0.000	0.000	0	-70	1	1.0253	8.17	220	2	1.05	0.95	;
	73	2	0.000	0.000	0	0	1	1.0309	16.22	220	2	1.05	0.95	;
	74	1	0.000	0.000	0	0	1	1.0248	-2.78	220	2	1.05	0.95	;
	75	1	0.000	0.000	0	0	1	1.0321	10.58	220	2	1.05	0.95	;
	76	1	0.000	0.000	0	0	1	1.0234	-4.22	220	2	1.05	0.95	;
	77	1	0.000	0.000	0	0	1	1.0357	18.84	220	2	1.05	0.95	;
	78	1	0.000	0.000	0	-70	1	1.0289	4.65	220	2	1.05	0.95	;
	79	1	0.000	0.000	0	0	1	1.0306	12.53	220	2	1.05	0.95	;
	80	1	0.000	0.000	0	0	1	1.0412	-2.3	400	2	1.05	0.95	;
	81	1	0.000	0.000	0	0	1	1.0375	9.21	400	2	1.05	0.95	;
	82	1	0.000	0.000	0	0	1	1.042	-1.08	400	2	1.05	0.95	;
	83	1	0.000	0.000	0	0	1	1.0445	4.29	400	2	1.05	0.95	;
	84	1	0.000	0.000	0	0	1	1.0404	-2.85	400	2	1.05	0.95	;
	85	1	0.000	0.000	0	-150	1	1.0408	2.3	400	2	1.05	0.95	;
	86	1	0.000	0.000	0	0	1	1.0407	-3.12	400	2	1.05	0.95	;
	87	1	0.000	0.000	0	0	1	1.0409	-3.36	400	2	1.05	0.95	;
	88	1	0.000	0.000	0	0	1	1.0414	10.82	400	2	1.05	0.95	;
	89	1	0.000	0.000	0	-150	1	1.0427	-1.19	400	2	1.05	0.95	;
	90	1	0.000	0.000	0	-150	1	1.046	11.1	400	2	1.05	0.95	;
	91	1	0.000	0.000	0	0	1	1.044	11.79	400	2	1.05	0.95	;
	92	1	0.000	0.000	0	-150	1	1.04	10.35	400	2	1.05	0.95	;
	93	1	0.000	0.000	0	0	1	1.0398	9.81	400	2	1.05	0.95	;
	94	1	0.000	0.000	0	0	1	1.0395	9.69	400	2	1.05	0.95	;
	95	1	0.000	0.000	0	0	1	1.0472	7.31	400	2	1.05	0.95	;
	96	1	0.000	0.000	0	0	1	1.0473	13.28	400	2	1.05	0.95	;
	97	2	0.000	0.000	0	0	1	1.0411	-2.78	400	2	1.05	0.95	;
	98	1	0.000	0.000	0	0	1	1.0462	6.15	400	2	1.05	0.95	;
	99	1	0.000	0.000	0	0	1	1.0469	5.72	400	2	1.05	0.95	;
	100	1	0.000	0.000	0	0	1	1.0431	-0.01	400	2	1.05	0.95	;
	101	1	0.000	0.000	0	-150	1	1.0425	7.91	400	2	1.05	0.95	;
	102	1	0.000	0.000	0	-150	1	1.0259	-4.85	400	2	1.05	0.95	;
	103	1	0.000	0.000	0	0	1	1.0459	9.44	400	2	1.05	0.95	;
	104	1	0.000	0.000	0	-150	1	1.042	11.62	400	2	1.05	0.95	;
	105	1	0.000	0.000	0	0	1	1.0419	0.77	400	2	1.05	0.95	;
	106	1	0.000	0.000	0	0	1	1.049	15.66	400	2	1.05	0.95	;
	107	2	0.000	0.000	0	0	1	1.03	-4.84	400	2	1.05	0.95	;
	108	2	50.077	14.121	0	0	1	1.0171	8.73	130	2	1.05	0.95	;
	109	2	257.443	37.476	0	0	1	1.0208	-3.65	63	2	1.05	0.95	;
	110	2	201.392	11.406	0	0	1	1.0266	-6.95	63	2	1.05	0.95	;
	111	2	193.028	23.137	0	0	1	1.0265	3.03	63	2	1.05	0.95	;
	112	2	244.300	34.000	0	0	1	1.0239	-7.43	63	2	1.05	0.95	;
	113	2	133.067	19.118	0	0	1	1.0285	-7.55	63	2	1.05	0.95	;
	114	2	231.265	31.502	0	0	1	1.0322	-0.21	63	2	1.05	0.95	;
	115	2	36.824	6.843	0	0	1	1.021	15.87	63	2	1.05	0.95	;
	116	2	292.530	58.115	0	0	1	1.0205	4.67	63	2	1.05	0.95	;
	117	2	74.083	9.016	0	0	1	1.0161	-8.97	63	2	1.05	0.95	;
	118	2	107.105	27.156	0	0	1	1.0274	5.79	63	2	1.05	0.95	;
	119	2	307.737	53.335	0	0	1	1.0384	-5.52	63	2	1.05	0.95	;
	120	2	267.003	49.751	0	0	1	1.0287	3.1	63	2	1.05	0.95	;
	121	2	157.508	29.872	0	0	1	1.0243	-10.79	63	2	1.05	0.95	;
	122	2	261.680	52.901	0	0	1	1.0389	0.34	63	2	1.05	0.95	;
	123	2	226.051	9.559	0	0	1	1.0317	-8.73	63	2	1.05	0.95	;
	124	2	161.309	42.255	0	0	1	1.0299	-2.28	63	2	1.05	0.95	;
	125	2	147.840	13.035	0	0	1	1.0252	-5.25	63	2	1.05	0.95	;
	126	2	120.901	15.968	0	0	1	1.0294	-5.69	63	2	1.05	0.95	;
	127	2	147.514	27.591	0	0	1	1.0275	6.06	63	2	1.05	0.95	;
	128	2	313.820	70.390	0	0	1	1.0315	8.06	63	2	1.05	0.95	;
	129	2	223.009	31.393	0	0	1	1.0293	3.41	63	2	1.05	0.95	;
	130	2	333.373	66.370	0	0	1	1.017	3.21	63	2	1.05	0.95	;
	131	2	185.207	30.089	0	0	1	1.0287	-3.41	63	2	1.05	0.95	;
	132	2	66.153	12.926	0	0	1	1.0133	2.65	63	2	1.05	0.95	;
	133	2	229.635	54.747	0	0	1	1.0286	8.56	63	2	1.05	0.95	;
	134	2	216.491	36.281	0	0	1	1.0251	4.3	63	2	1.05	0.95	;
	135	2	217.360	22.486	0	0	1	1.0261	-6.82	63	2	1.05	0.95	;
	136	2	282.645	33.457	0	0	1	1.0284	-8.95	63	2	1.05	0.95	;
	137	2	159.463	40.300	0	0	1	1.028	6.91	63	2	1.05	0.95	;
	138	2	170.434	31.067	0	0	1	1.0239	5.46	63	2	1.05	0.95	;
	139	2	209.105	23.572	0	0	1	1.0268	-7.51	63	2	1.05	0.95	;
	140	2	56.268	9.668	0	0	1	1.0194	-9.78	63	2	1.05	0.95	;
	141	2	118.294	9.994	0	0	1	1.0243	-9.35	63	2	1.05	0.95	;
	142	2	173.041	29.655	0	0	1	1.0316	6.4	63	2	1.05	0.95	;
	143	1	103.738	10.971	0	0	1	1.0178	-7.02	63	2	1.05	0.95	;
	144	2	84.728	9.016	0	0	1	1.0282	6.2	63	2	1.05	0.95	;
	145	2	220.511	43.559	0	0	1	1.0258	6.86	63	2	1.05	0.95	;
	146	2	20.639	3.150	0	0	1	1.0199	-7.16	63	2	1.05	0.95	;
	147	2	79.406	10.971	0	0	1	1.0258	-4.76	63	2	1.05	0.95	;
	148	1	0.000	0.000	0	0	1	1.008	11.47	63	2	1.05	0.95	;
	149	2	204.760	35.303	0	0	1	1.0252	-12.6	63	2	1.05	0.95	;
	150	2	51.489	10.971	0	0	1	1.0148	8.07	63	2	1.05	0.95	;
	151	2	251.686	63.546	0	0	1	1.0231	6.43	63	2	1.05	0.95	;
	152	2	86.792	20.965	0	0	1	1.021	7.56	63	2	1.05	0.95	;
	153	2	13.144	3.367	0	0	1	1.0301	20.01	63	2	1.05	0.95	;
	154	2	105.476	10.645	0	0	1	1.0192	-4.85	63	2	1.05	0.95	;
	155	2	64.958	16.403	0	0	1	1.031	8.44	63	2	1.05	0.95	;
	156	2	35.629	7.169	0	0	1	1.0238	8.24	63	2	1.05	0.95	;
	157	2	146.645	23.572	0	0	1	1.0216	2.43	63	2	1.05	0.95	;
	158	2	106.128	19.879	0	0	1	1.0303	5.41	63	2	1.05	0.95	;
	159	2	115.035	19.118	0	0	1	1.0336	-10.32	63	2	1.05	0.95	;
	160	2	119.706	14.121	0	0	1	1.0343	7.47	63	2	1.05	0.95	;
	161	2	19.444	5.540	0	0	1	1.0245	2.14	63	2	1.05	0.95	;
	162	2	75.169	13.361	0	0	1	1.0199	6.51	63	2	1.05	0.95	;
	163	2	14.773	9.994	0	0	1	1.0248	13.18	63	2	1.05	0.95	;
	164	2	46.057	5.540	0	0	1	1.026	-0.25	63	2	1.05	0.95	;
	165	2	56.920	14.013	0	0	1	1.0078	14.87	63	2	1.05	0.95	;
	166	2	146.645	20.313	0	0	1	1.0259	-6.31	63	2	1.05	0.95	;
	167	2	42.473	7.821	0	0	1	1.0086	10.26	63	2	1.05	0.95	;
	168	2	163.156	29.003	0	0	1	1.0285	-5.18	63	2	1.05	0.95	;
	169	2	21.291	12.709	0	0	1	1.031	-7.44	63	2	1.05	0.95	;
	170	2	42.690	12.166	0	0	1	1.0246	3.62	63	2	1.05	0.95	;
	171	2	73.540	8.256	0	0	1	1.0258	2.72	63	2	1.05	0.95	;
	172	2	44.863	8.256	0	0	1	1.0074	11.72	63	2	1.05	0.95	;
	173	2	0.000	0.000	0	0	1	1.0392	13.56	150	2	1.05	0.95	;
	174	2	0.000	0.000	0	0	1	1.0381	13.1	150	2	1.05	0.95	;
	175	2	0.000	0.000	0	0	1	1.0116	-0.55	150	2	1.05	0.95	;
	176	2	0.000	0.000	0	0	1	1.0115	-0.55	150	2	1.05	0.95	;
	177	2	0.000	0.000	0	0	1	1.0408	13.8	150	2	1.05	0.95	;
	178	2	0.000	0.000	0	0	1	1.0276	11.94	150	2	1.05	0.95	;
	179	2	0.000	0.000	0	0	1	1.0378	12.49	150	2	1.05	0.95	;
	180	1	0.000	0.000	0	0	1	1.031	-5.92	150	2	1.05	0.95	;
	181	2	0.000	0.000	0	0	1	1.0281	8.7	150	2	1.05	0.95	;
	182	2	0.000	0.000	0	0	1	1.0387	13.44	150	2	1.05	0.95	;
	184	1	0.000	0.000	0	0	1	1.0349	11.94	150	2	1.05	0.95	;
	185	1	0.000	0.000	0	0	1	1.0344	-5.45	150	2	1.05	0.95	;
	186	1	0.000	0.000	0	0	1	1.0284	-6.57	150	2	1.05	0.95	;
	187	2	0.000	0.000	0	0	1	1.0216	-0.71	220	2	1.05	0.95	;
	188	2	0.000	0.000	0	0	1	1.0216	-0.71	220	2	1.05	0.95	;
	189	2	0.000	0.000	0	0	1	1.0216	-0.71	220	2	1.05	0.95	;
	190	1	0.000	0.000	0	0	1	1.0215	6.3	220	2	1.05	0.95	;
	191	2	0.000	0.000	0	0	1	1.0488	23.76	220	2	1.05	0.95	;
	192	2	0.000	0.000	0	0	1	1.0435	21.13	220	2	1.05	0.95	;
	193	1	0.000	0.000	0	0	1	1.0227	6.47	220	2	1.05	0.95	;
	194	2	0.000	0.000	0	0	1	1.0429	14.69	220	2	1.05	0.95	;
	195	2	0.000	0.000	0	0	1	1.0345	4.79	220	2	1.05	0.95	;
	196	2	0.000	0.000	0	0	1	1.0474	16.02	220	2	1.05	0.95	;
	198	2	0.000	0.000	0	0	1	1.0484	17.17	220	2	1.05	0.95	;
	199	1	0.000	0.000	0	0	1	1.0286	1.49	220	2	1.05	0.95	;
	200	2	0.000	0.000	0	0	1	1.0467	22.64	220	2	1.05	0.95	;
	201	2	0.000	0.000	0	0	1	1.0467	22.64	220	2	1.05	0.95	;
	202	2	0.000	0.000	0	0	1	1.0467	22.64	220	2	1.05	0.95	;
	203	2	0.000	0.000	0	0	1	1.0468	22.67	220	2	1.05	0.95	;
	204	1	0.000	0.000	0	0	1	1.0243	-4.05	220	2	1.05	0.95	;
	205	1	0.000	0.000	0	0	1	1.0242	-4.21	220	2	1.05	0.95	;
	206	2	0.000	0.000	0	0	1	1.0316	8.32	220	2	1.05	0.95	;
	207	2	0.000	0.000	0	0	1	1.0316	8.32	220	2	1.05	0.95	;
	208	1	0.000	0.000	0	0	1	1.0245	6.54	220	2	1.05	0.95	;
	209	1	0.000	0.000	0	0	1	1.0249	6.56	220	2	1.05	0.95	;
	210	1	0.000	0.000	0	0	1	1.0247	6.61	220	2	1.05	0.95	;
	211	1	0.000	0.000	0	0	1	1.0253	6.66	220	2	1.05	0.95	;
	212	1	0.000	0.000	0	0	1	1.0312	8.58	220	2	1.05	0.95	;
	213	1	0.000	0.000	0	0	1	1.026	-3.74	220	2	1.05	0.95	;
	214	1	0.000	0.000	0	0	1	1.026	-3.73	220	2	1.05	0.95	;
	215	1	0.000	0.000	0	0	1	1.026	-3.75	220	2	1.05	0.95	;
	216	1	0.000	0.000	0	0	1	1.026	-3.73	220	2	1.05	0.95	;
	217	1	0.000	0.000	0	0	1	1.0272	-3.78	220	2	1.05	0.95	;
	218	2	0.000	0.000	0	0	1	1.0329	8.95	220	2	1.05	0.95	;
	219	1	0.000	0.000	0	0	1	1.0238	-4.23	220	2	1.05	0.95	;
	220	1	0.000	0.000	0	0	1	1.0236	6.65	220	2	1.05	0.95	;
	221	1	0.000	0.000	0	0	1	1.0236	6.65	220	2	1.05	0.95	;
	222	2	0.000	0.000	0	0	1	1.0258	-2.39	220	2	1.05	0.95	;
	223	1	0.000	0.000	0	0	1	1.0311	4.69	220	2	1.05	0.95	;
	224	1	0.000	0.000	0	0	1	1.0304	8.23	220	2	1.05	0.95	;
	225	2	0.000	0.000	0	0	1	1.0487	16.24	400	2	1.05	0.95	;
	226	1	0.000	0.000	0	0	1	1.0433	-2.8	400	2	1.05	0.95	;
	227	2	0.000	0.000	0	0	1	1.0418	0.79	400	2	1.05	0.95	;
	228	2	0.000	0.000	0	0	1	1.0418	0.79	400	2	1.05	0.95	;
	229	2	0.000	0.000	0	0	1	1.044	11.79	400	2	1.05	0.95	;
	230	2	0.000	0.000	0	0	1	1.0446	11.87	400	2	1.05	0.95	;
	231	2	0.000	0.000	0	0	1	1.0476	11.86	400	2	1.05	0.95	;
	232	2	0.000	0.000	0	0	1	1.0473	13.28	400	2	1.05	0.95	;
	233	2	0.000	0.000	0	0	1	1.0473	13.28	400	2	1.05	0.95	;
	239	3	0.000	0.000	0	0	1	1.0431	0	400	2	1.05	0.95	;
	240	2	0.000	0.000	0	0	1	1.0431	-0.01	400	2	1.05	0.95	;
	241	2	0.000	0.000	0	0	1	1.0482	7.81	400	2	1.05	0.95	;
	242	2	0.000	0.000	0	0	1	1.0482	7.74	400	2	1.05	0.95	;
	243	2	0.000	0.000	0	0	1	1.0469	5.72	400	2	1.05	0.95	;
	244	2	0.000	0.000	0	0	1	1.0469	5.72	400	2	1.05	0.95	;
	245	1	36.933	9.994	0	0	1	1.0219	-7.37	150	2	1.05	0.95	;
	246	1	16.294	3.367	0	0	1	1.0305	-5.97	150	2	1.05	0.95	;
	247	1	4.888	-0.435	0	0	1	1.0283	-6.6	150	2	1.05	0.95	;
	248	1	1.086	-0.652	0	0	1	1.0219	7.73	150	2	1.05	0.95	;
	249	1	5.974	-0.217	0	0	1	1.031	-5.95	150	2	1.05	0.95	;
	250	2	17.380	5.757	0	0	1	1.0368	-4.64	150	2	1.05	0.95	;
	251	2	0.000	0.000	0	0	1	1.0291	10.4	150	2	1.05	0.95	;
	252	2	0.000	0.000	0	0	1	1.0224	7.93	150	2	1.05	0.95	;
	253	2	0.000	0.000	0	0	1	1.0219	7.89	150	2	1.05	0.95	;
	254	2	0.000	0.000	0	0	1	1.0323	11.48	150	2	1.05	0.95	;
	255	2	27.156	9.885	0	0	1	1.0383	-4.13	150	2	1.05	0.95	;
	256	1	103.195	29.655	0	0	1	1.0207	6.21	220	2	1.05	0.95	;
	257	1	3.259	-2.607	0	0	1	1.0342	7.97	220	2	1.05	0.95	;
	258	1	3.259	-2.498	0	0	1	1.0308	4.03	220	2	1.05	0.95	;
	259	1	2.716	-2.716	0	0	1	1.0354	8.93	220	2	1.05	0.95	;
	260	1	135.782	35.195	0	0	1	0.9957	-5.99	220	2	1.05	0.95	;
	261	1	1.086	-1.629	0	0	1	1.0295	8.36	220	2	1.05	0.95	;
	262	2	0.000	0.000	0	0	1	1.0315	4.73	220	2	1.05	0.95	;
	263	2	0.000	0.000	0	0	1	1.0308	8.61	220	2	1.05	0.95	;
	264	2	0.000	0.000	0	0	1	1.0305	8.24	220	2	1.05	0.95	;
	265	2	0.000	0.000	0	0	1	1.0311	4.69	220	2	1.05	0.95	;
	266	2	0.000	0.000	0	0	1	1.0312	8.58	220	2	1.05	0.95	;
	267	2	0.000	0.000	0	0	1	1.0321	10.58	220	2	1.05	0.95	;
	268	2	0.000	0.000	0	0	1	1.0466	11.11	400	2	1.05	0.95	;
	269	1	0.000	0.000	0	0	1	1.0183	15.63	63	2	1.05	0.95	;
	270	1	0.000	0.000	0	0	1	1.0183	15.63	63	2	1.05	0.95	;
	271	1	0.000	0.000	0	0	1	1.0161	15.45	63	2	1.05	0.95	;
	272	1	0.000	0.000	0	0	1	1.0109	15.07	63	2	1.05	0.95	;
	273	2	0.000	0.000	0	0	1	1.0311	5.56	63	2	1.05	0.95	;
	274	1	0.000	0.000	0	0	1	1.0307	5.52	63	2	1.05	0.95	;
	275	1	0.000	0.000	0	0	1	1.0301	5.47	63	2	1.05	0.95	;
	276	1	0.000	0.000	0	0	1	1.0243	4.99	63	2	1.05	0.95	;
	277	1	0.000	0.000	0	0	1	1.024	4.95	63	2	1.05	0.95	;
	278	1	0.000	0.000	0	0	1	1.023	4.87	63	2	1.05	0.95	;
	279	1	0.000	0.000	0	0	1	1.0209	4.7	63	2	1.05	0.95	;
	280	1	0.000	0.000	0	0	1	1.0203	3.74	63	2	1.05	0.95	;
	281	1	0.000	0.000	0	0	1	1.0254	4.53	63	2	1.05	0.95	;
	282	1	0.000	0.000	0	0	1	1.0292	5.21	63	2	1.05	0.95	;
	283	1	0.000	0.000	0	0	1	1.0133	2.66	63	2	1.05	0.95	;
	284	1	0.000	0.000	0	0	1	1.0218	5.72	63	2	1.05	0.95	;
	285	1	0.000	0.000	0	0	1	1.022	5.77	63	2	1.05	0.95	;
	286	1	0.000	0.000	0	0	1	1.0255	6.81	63	2	1.05	0.95	;
	287	1	0.000	0.000	0	0	1	1.0321	11.98	150	2	1.05	0.95	;
	288	1	0.000	0.000	0	0	1	1.032	11.98	150	2	1.05	0.95	;
	289	1	0.000	0.000	0	0	1	1.0339	12.52	150	2	1.05	0.95	;
	290	1	0.000	0.000	0	0	1	1.0357	13	150	2	1.05	0.95	;
	291	1	0.000	0.000	0	0	1	1.0362	13.16	150	2	1.05	0.95	;
	292	1	0.000	0.000	0	0	1	1.0363	13.18	150	2	1.05	0.95	;
	293	2	0.000	0.000	0	0	1	1.0424	14.15	150	2	1.05	0.95	;
	294	1	0.000	0.000	0	0	1	1.0083	11.03	63	2	1.05	0.95	;
	295	1	0.000	0.000	0	0	1	1.0086	10.48	63	2	1.05	0.95	;
	296	1	0.000	0.000	0	0	1	1.0086	10.37	63	2	1.05	0.95	;
	297	1	0.000	0.000	0	0	1	1.0086	10.33	63	2	1.05	0.95	;
	298	1	0.000	0.000	0	0	1	1.009	14.15	63	2	1.05	0.95	;
	299	1	0.000	0.000	0	0	1	1.009	14.15	63	2	1.05	0.95	;
	300	1	0.000	0.000	0	0	1	1.009	14.16	63	2	1.05	0.95	;
	301	1	0.000	0.000	0	0	1	1.0089	13.48	63	2	1.05	0.95	;
	302	1	0.000	0.000	0	0	1	1.0086	12.86	63	2	1.05	0.95	;
	303	1	0.000	0.000	0	0	1	1.008	12.15	63	2	1.05	0.95	;
	304	1	0.000	0.000	0	0	1	1.008	12.15	63	2	1.05	0.95	;
	306	1	0.000	0.000	0	0	1	1.0276	10.79	150	2	1.05	0.95	;
	307	1	0.000	0.000	0	0	1	1.0266	10.71	150	2	1.05	0.95	;
	308	1	21.725	4.345	0	0	1	1.0246	6.54	220	2	1.05	0.95	;
	309	2	0.000	0.000	0	0	1	1.0324	8.54	220	2	1.05	0.95	;
	310	1	0.000	0.000	0	0	1	1.0489	12.73	400	2	1.05	0.95	;
	311	2	0.000	0.000	0	0	1	1.0471	11.47	400	2	1.05	0.95	;
	312	1	0.000	0.000	0	0	1	1.0427	11.07	400	2	1.05	0.95	;
	313	2	0.000	0.000	0	0	1	1.0485	1.86	400	2	1.05	0.95	;
	314	2	0.000	0.000	0	0	1	1.0376	-3.4	400	2	1.05	0.95	;
	315	2	0.000	0.000	0	0	1	1.0475	-0.56	400	2	1.05	0.95	;
	316	2	18.466	-2.390	0	0	1	1.0487	3.11	400	2	1.05	0.95	;
	317	2	0.000	0.000	0	0	1	1.049	13.59	400	2	1.05	0.95	;
	318	1	0.000	0.000	0	0	1	1.0482	8.93	400	2	1.05	0.95	;
	319	2	169.456	35.955	0	0	1	1.0314	8.78	63	2	1.05	0.95	;
	320	2	48.447	8.147	0	0	1	1.0303	1.59	63	2	1.05	0.95	;
	321	2	27.591	3.911	0	0	1	1.0251	-0.86	63	2	1.05	0.95	;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf
mpc.gen = [
	1	497.678	-50.752	9999.000	-9999.000	1.0483	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	2	59.236	-78.217	9999.000	-9999.000	1.0482	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	3	18.105	-87.286	9999.000	-9999.000	1.0420	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	4	27.812	-58.022	9999.000	-9999.000	1.0373	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	5	156.397	-22.000	9999.000	-9999.000	1.0486	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	6	100.683	-14.204	9999.000	-9999.000	1.0482	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	7	0.000	7.649	9999.000	-9999.000	1.0329	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	305	151.749	-16.046	9999.000	-9999.000	1.0457	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	10	0.000	0.000	54.532	-54.532	1.0374	146.83	0	136.329	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	14	0.000	0.000	62.824	-62.824	1.0327	169.16	0	157.060	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	22	0.000	0.000	39.545	-39.545	1.0301	106.48	0	98.862	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	22	0.000	0.000	53.269	-53.269	1.0301	143.43	0	133.174	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	24	0.000	0.000	62.824	-62.824	1.0233	169.16	0	157.060	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	29	0.000	0.000	40.899	-40.899	1.0272	110.12	0	102.247	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	30	31.000	1.793	15.500	-12.400	1.0354	34.66	1	31.000	15.500	0	0	0	0	0	0	0	0	0	0	0	;
	30	0.000	0.000	15.500	-12.400	1.0354	34.66	0	31.000	15.500	0	0	0	0	0	0	0	0	0	0	0	;
	34	0.000	0.000	68.165	-68.165	1.0318	183.54	0	170.411	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	61	50.000	3.582	30.000	-24.000	1.0307	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	61	58.000	3.582	30.000	-24.000	1.0307	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	61	0.000	0.000	30.000	-24.000	1.0307	67.08	0	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	64	0.000	0.000	43.506	-43.506	1.0219	117.14	0	108.764	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	65	1.675	7.021	27.669	-27.669	1.0368	74.50	1	69.172	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	73	2.867	6.698	47.355	-47.355	1.0309	127.51	1	118.388	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	97	0.000	0.000	62.824	-62.824	1.0411	169.16	0	157.060	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	107	0.000	0.000	109.063	-109.063	1.0300	293.66	0	272.658	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	108	1.906	11.263	31.486	-31.486	1.0171	84.78	1	78.714	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	108	8.392	3.322	9.285	-9.285	1.0171	25.00	1	23.212	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	15.000	3.076	7.750	-6.200	1.0208	17.33	1	15.500	7.750	0	0	0	0	0	0	0	0	0	0	0	;
	109	30.000	5.953	15.000	-12.000	1.0208	33.54	1	30.000	15.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	36.839	8.802	24.615	-24.615	1.0208	66.28	1	61.537	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	2.502	14.779	41.328	-41.328	1.0208	111.28	1	103.319	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	5.270	0.000	0.000	0.000	1.0208	15.70	1	15.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	0.000	0.000	6.978	-6.978	1.0208	18.79	0	17.444	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	110	11.271	-1.166	7.531	-7.531	1.0266	20.28	1	18.827	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	110	0.000	0.000	5.622	-5.622	1.0266	15.14	0	14.054	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	111	4.767	0.484	3.185	-3.185	1.0265	8.58	1	7.964	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	112	117.434	7.332	78.466	-78.466	1.0239	211.28	1	196.166	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	112	0.000	0.000	15.297	-15.297	1.0239	41.19	0	38.242	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	113	1.933	-0.026	1.291	-1.291	1.0285	3.48	1	3.228	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	113	2.249	0.000	0.000	0.000	1.0285	6.70	1	6.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	113	0.000	0.000	39.116	-39.116	1.0285	105.32	0	97.789	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	17.107	4.576	11.430	-11.430	1.0322	30.78	1	28.576	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	4.440	29.360	73.341	-73.341	1.0322	197.48	1	183.354	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	4.531	0.000	0.000	0.000	1.0322	13.50	1	13.500	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	9.063	4.014	10.028	-10.028	1.0322	27.00	1	25.069	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	0.000	0.000	7.126	-7.126	1.0322	19.19	0	17.816	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	15.000	0.795	9.000	-7.200	1.0210	20.12	1	18.000	-18.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	15.000	0.795	9.000	-7.200	1.0210	20.12	1	18.000	-18.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	2.155	0.021	1.440	-1.440	1.0210	3.88	1	3.600	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	1.767	0.431	29.183	-29.183	1.0210	78.58	1	72.958	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	3.424	0.000	0.000	0.000	1.0210	10.20	1	10.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	116	39.729	14.325	26.546	-26.546	1.0205	71.48	1	66.365	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	116	0.604	0.000	0.000	0.000	1.0205	1.80	1	1.800	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	116	0.000	0.000	6.346	-6.346	1.0205	17.09	0	15.866	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	117	1.599	0.111	1.069	-1.069	1.0161	2.88	1	2.671	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	117	0.000	0.000	11.583	-11.583	1.0161	31.19	0	28.957	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	118	23.110	6.227	15.441	-15.441	1.0274	41.58	1	38.603	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	118	1.609	10.719	26.583	-26.583	1.0274	71.58	1	66.458	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	118	8.224	0.000	0.000	0.000	1.0274	24.50	1	24.500	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	118	26.685	11.906	29.526	-29.526	1.0274	79.50	1	73.814	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	119	4.489	0.711	3.000	-3.000	1.0384	8.08	1	7.499	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	119	2.398	9.390	39.619	-39.619	1.0384	106.68	1	99.048	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	119	0.000	0.000	6.346	-6.346	1.0384	17.09	0	15.866	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	120	16.884	6.610	11.282	-11.282	1.0287	30.38	1	28.204	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	120	2.567	24.844	42.405	-42.405	1.0287	114.18	1	106.011	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	120	6.713	0.000	0.000	0.000	1.0287	20.00	1	20.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	120	0.000	0.000	7.238	-7.238	1.0287	19.49	0	18.094	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	121	1.726	18.191	28.515	-28.515	1.0243	76.78	1	71.286	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	121	0.336	0.000	0.000	0.000	1.0243	1.00	1	1.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	121	0.000	0.000	17.156	-17.156	1.0243	46.19	0	42.890	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	122	13.438	4.712	8.979	-8.979	1.0389	24.18	1	22.448	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	122	4.806	41.663	79.395	-79.395	1.0389	213.78	1	198.488	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	122	0.000	0.000	5.641	-5.641	1.0389	15.19	0	14.102	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	123	26.278	2.032	17.558	-17.558	1.0317	47.28	1	43.896	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	123	0.000	0.000	12.660	-12.660	1.0317	34.09	0	31.650	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	124	1.655	0.646	1.106	-1.106	1.0299	2.98	1	2.764	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	124	6.490	62.655	107.212	-107.212	1.0299	288.68	1	268.030	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	124	0.436	0.000	0.000	0.000	1.0299	1.30	1	1.300	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	125	1.964	5.483	32.451	-32.451	1.0252	87.38	1	81.128	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	126	21.553	-0.822	14.401	-14.401	1.0294	38.78	1	36.004	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	126	2.036	-1.920	33.640	-33.640	1.0294	90.58	1	84.099	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	126	0.000	0.000	15.955	-15.955	1.0294	42.96	0	39.888	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	2.099	0.305	1.403	-1.403	1.0275	3.78	1	3.507	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	9.197	33.012	151.928	-151.928	1.0275	409.08	1	379.819	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	15.407	0.000	0.000	0.000	1.0275	45.90	1	45.900	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	10.322	2.481	11.420	-11.420	1.0275	30.75	1	28.551	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	0.000	0.000	5.622	-5.622	1.0275	15.14	0	14.054	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	128	91.421	35.371	61.085	-61.085	1.0315	164.48	1	152.713	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	128	1.629	15.586	26.918	-26.918	1.0315	72.48	1	67.294	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	128	15.273	0.000	0.000	0.000	1.0315	45.50	1	45.500	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	128	0.000	0.000	6.569	-6.569	1.0315	17.69	0	16.423	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	129	63.000	17.192	37.500	-30.000	1.0293	83.85	1	75.000	37.500	0	0	0	0	0	0	0	0	0	0	0	;
	129	41.230	11.737	27.549	-27.549	1.0293	74.18	1	68.871	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	129	2.353	16.564	38.876	-38.876	1.0293	104.68	1	97.191	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	129	6.143	0.000	0.000	0.000	1.0293	18.30	1	18.300	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	130	6.379	1.120	4.262	-4.262	1.0170	11.48	1	10.656	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	131	48.511	-2.575	32.414	-32.414	1.0287	87.28	1	81.035	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	131	2.902	-3.809	47.938	-47.938	1.0287	129.08	1	119.846	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	131	0.000	0.000	12.400	-12.400	1.0287	33.39	0	31.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	132	20.053	3.167	13.399	-13.399	1.0133	36.08	1	33.497	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	132	2.063	8.057	34.085	-34.085	1.0133	91.78	1	85.214	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	132	0.000	0.000	5.622	-5.622	1.0133	15.14	0	14.054	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	133	77.803	25.460	51.986	-51.986	1.0286	139.98	1	129.965	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	133	4.406	35.645	72.784	-72.784	1.0286	195.98	1	181.961	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	133	5.606	0.000	0.000	0.000	1.0286	16.70	1	16.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	134	104.761	45.093	69.999	-69.999	1.0251	188.48	1	174.996	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	134	0.000	0.000	6.049	-6.049	1.0251	16.29	0	15.123	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	135	0.139	0.051	2.300	-2.300	1.0261	6.19	1	5.750	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	136	4.601	-0.141	3.074	-3.074	1.0284	8.28	1	7.685	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	136	0.000	0.000	7.089	-7.089	1.0284	19.09	0	17.723	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	137	17.274	6.342	11.542	-11.542	1.0280	31.08	1	28.854	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	137	2.551	23.157	42.145	-42.145	1.0280	113.48	1	105.361	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	137	1.645	0.000	0.000	0.000	1.0280	4.90	1	4.900	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	138	4.601	0.335	3.074	-3.074	1.0239	8.28	1	7.685	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	138	2.215	0.000	0.000	0.000	1.0239	6.60	1	6.600	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	138	0.000	0.000	7.758	-7.758	1.0239	20.89	0	19.394	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	139	6.435	-0.046	4.300	-4.300	1.0268	11.58	1	10.749	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	139	0.000	0.000	5.622	-5.622	1.0268	15.14	0	14.054	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	140	2.316	0.000	0.000	0.000	1.0194	6.90	1	6.900	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	140	0.000	0.000	42.668	-42.668	1.0194	114.89	0	106.671	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	141	8.380	0.690	5.599	-5.599	1.0243	15.08	1	13.999	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	141	0.000	0.000	5.622	-5.622	1.0243	15.14	0	14.054	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	142	11.993	3.884	8.014	-8.014	1.0316	21.58	1	20.034	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	142	4.100	32.832	67.733	-67.733	1.0316	182.38	1	169.333	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	142	9.264	0.000	0.000	0.000	1.0316	27.60	1	27.600	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	142	0.000	0.000	5.641	-5.641	1.0316	15.19	0	14.102	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	144	2.155	0.296	1.440	-1.440	1.0282	3.88	1	3.600	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	144	4.055	13.747	66.991	-66.991	1.0282	180.38	1	167.477	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	145	225.710	32.810	150.813	-150.813	1.0258	406.08	1	377.033	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	145	1.767	6.349	29.183	-29.183	1.0258	78.58	1	72.958	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	146	0.000	0.000	12.181	-12.181	1.0199	32.80	0	30.452	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	147	4.323	-0.181	2.888	-2.888	1.0258	7.78	1	7.221	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	147	0.000	0.000	7.089	-7.089	1.0258	19.09	0	17.723	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	149	2.211	0.362	1.477	-1.477	1.0252	3.98	1	3.693	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	149	0.000	0.000	11.151	-11.151	1.0252	30.03	0	27.878	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	4.000	-3.200	1.0148	8.94	0	8.000	4.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	7.000	0.354	4.400	-3.520	1.0148	9.84	1	8.800	4.400	0	0	0	0	0	0	0	0	0	0	0	;
	150	7.000	0.354	4.400	-3.520	1.0148	9.84	1	8.800	4.400	0	0	0	0	0	0	0	0	0	0	0	;
	150	7.000	0.354	4.400	-3.520	1.0148	9.84	1	8.800	4.400	0	0	0	0	0	0	0	0	0	0	0	;
	150	7.000	0.354	4.400	-3.520	1.0148	9.84	1	8.800	4.400	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	4.000	-3.200	1.0148	8.94	0	8.000	4.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	12.500	-10.000	1.0148	27.95	0	25.000	12.500	0	0	0	0	0	0	0	0	0	0	0	;
	150	30.836	0.126	20.604	-20.604	1.0148	55.48	1	51.509	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	2.958	0.300	48.867	-48.867	1.0148	131.58	1	122.167	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	1.880	0.000	0.000	0.000	1.0148	5.60	1	5.600	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	14.517	-14.517	1.0148	39.09	0	36.292	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	151	16.607	6.125	11.096	-11.096	1.0231	29.88	1	27.740	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	151	3.760	0.000	0.000	0.000	1.0231	11.20	1	11.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	151	0.000	0.000	5.622	-5.622	1.0231	15.14	0	14.054	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	15.773	-0.061	10.539	-10.539	1.0210	28.38	1	26.347	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	3.761	-0.358	62.125	-62.125	1.0210	167.28	1	155.314	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	8.996	0.000	0.000	0.000	1.0210	26.80	1	26.800	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	11.077	-0.071	12.256	-12.256	1.0210	33.00	1	30.640	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	0.000	0.000	5.641	-5.641	1.0210	15.19	0	14.102	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	153	1.677	2.436	27.698	-27.698	1.0301	74.58	1	69.244	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	153	0.000	0.000	5.641	-5.641	1.0301	15.19	0	14.102	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	154	3.878	0.145	2.591	-2.591	1.0192	6.98	1	6.478	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	154	0.000	0.000	6.235	-6.235	1.0192	16.79	0	15.587	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	155	0.000	0.000	20.000	-16.000	1.0310	44.72	0	40.000	20.000	0	0	0	0	0	0	0	0	0	0	0	;
	155	1.766	0.370	1.180	-1.180	1.0310	3.18	1	2.950	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	155	7.382	38.265	121.956	-121.956	1.0310	328.38	1	304.891	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	155	6.780	0.000	0.000	0.000	1.0310	20.20	1	20.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	156	6.769	15.856	111.818	-111.818	1.0238	301.08	1	279.544	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	156	3.256	0.000	0.000	0.000	1.0238	9.70	1	9.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	157	11.493	2.537	7.679	-7.679	1.0216	20.68	1	19.198	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	158	3.155	1.032	2.108	-2.108	1.0303	5.68	1	5.271	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	158	2.987	24.168	49.350	-49.350	1.0303	132.88	1	123.374	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	158	0.000	0.000	5.622	-5.622	1.0303	15.14	0	14.054	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	159	5.545	2.268	3.705	-3.705	1.0336	9.98	1	9.263	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	159	5.348	54.078	88.346	-88.346	1.0336	237.88	1	220.864	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	159	0.906	0.000	0.000	0.000	1.0336	2.70	1	2.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	159	0.000	0.000	3.774	-3.774	1.0336	10.16	0	9.436	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	160	16.217	1.959	10.836	-10.836	1.0343	29.18	1	27.090	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	160	5.914	17.664	97.705	-97.705	1.0343	263.08	1	244.262	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	160	18.562	0.000	0.000	0.000	1.0343	55.30	1	55.300	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	161	6.607	16.145	109.143	-109.143	1.0245	293.88	1	272.859	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	162	34.226	7.773	22.869	-22.869	1.0199	61.58	1	57.173	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	162	2.531	14.211	41.810	-41.810	1.0199	112.58	1	104.526	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	162	1.074	0.000	0.000	0.000	1.0199	3.20	1	3.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	163	6.431	8.593	106.247	-106.247	1.0248	286.08	1	265.616	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	163	2.417	0.000	0.000	0.000	1.0248	7.20	1	7.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	164	4.531	0.000	0.000	0.000	1.0260	13.50	1	13.500	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	164	0.000	0.000	39.459	-39.459	1.0260	106.25	0	98.647	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	165	3.257	6.622	53.806	-53.806	1.0078	144.88	1	134.516	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	165	7.083	0.000	0.000	0.000	1.0078	21.10	1	21.100	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	166	12.215	1.918	8.162	-8.162	1.0259	21.98	1	20.405	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	166	6.847	26.579	113.117	-113.117	1.0259	304.58	1	282.793	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	166	0.000	0.000	5.678	-5.678	1.0259	15.29	0	14.194	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	167	2.099	-0.105	1.403	-1.403	1.0086	3.78	1	3.507	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	167	4.197	-5.181	69.330	-69.330	1.0086	186.68	1	173.326	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	167	12.520	0.000	0.000	0.000	1.0086	37.30	1	37.300	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	168	4.156	0.374	2.777	-2.777	1.0285	7.48	1	6.942	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	168	0.000	0.000	5.622	-5.622	1.0285	15.14	0	14.054	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	169	5.011	47.170	82.775	-82.775	1.0310	222.88	1	206.937	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	169	0.000	0.000	5.662	-5.662	1.0310	15.24	0	14.154	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	170	3.675	31.167	60.714	-60.714	1.0246	163.48	1	151.785	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	170	1.343	0.000	0.000	0.000	1.0246	4.00	1	4.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	171	0.356	0.000	0.000	0.000	1.0258	1.06	1	1.060	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	171	0.000	0.000	10.060	-10.060	1.0258	27.09	0	25.150	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	172	2.785	3.626	46.007	-46.007	1.0074	123.88	1	115.018	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	172	11.211	0.000	0.000	0.000	1.0074	33.40	1	33.400	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	173	30.000	0.712	15.000	-12.000	1.0392	33.54	1	30.000	15.000	0	0	0	0	0	0	0	0	0	0	0	;
	173	30.000	0.712	15.000	-12.000	1.0392	33.54	1	30.000	15.000	0	0	0	0	0	0	0	0	0	0	0	;
	173	30.000	0.712	15.000	-12.000	1.0392	33.54	1	30.000	15.000	0	0	0	0	0	0	0	0	0	0	0	;
	173	54.000	1.282	27.000	-21.600	1.0392	60.37	1	54.000	27.000	0	0	0	0	0	0	0	0	0	0	0	;
	174	16.000	1.292	10.500	-8.400	1.0381	23.48	1	21.000	10.500	0	0	0	0	0	0	0	0	0	0	0	;
	174	0.000	0.000	10.500	-8.400	1.0381	23.48	0	21.000	10.500	0	0	0	0	0	0	0	0	0	0	0	;
	175	0.000	0.000	27.000	-21.600	1.0116	60.37	0	54.000	27.000	0	0	0	0	0	0	0	0	0	0	0	;
	175	0.000	0.000	27.000	-21.600	1.0116	60.37	0	54.000	27.000	0	0	0	0	0	0	0	0	0	0	0	;
	176	16.000	0.212	11.000	-8.800	1.0115	24.60	1	22.000	11.000	0	0	0	0	0	0	0	0	0	0	0	;
	176	0.000	0.000	11.000	-8.800	1.0115	24.60	0	22.000	11.000	0	0	0	0	0	0	0	0	0	0	0	;
	177	31.000	-0.374	17.000	-13.600	1.0408	38.01	1	34.000	-34.000	0	0	0	0	0	0	0	0	0	0	0	;
	177	0.000	0.000	17.000	-13.600	1.0408	38.01	0	34.000	-34.000	0	0	0	0	0	0	0	0	0	0	0	;
	178	28.000	0.499	14.500	-11.600	1.0276	32.42	1	29.000	14.500	0	0	0	0	0	0	0	0	0	0	0	;
	178	28.000	0.499	14.500	-11.600	1.0276	32.42	1	29.000	14.500	0	0	0	0	0	0	0	0	0	0	0	;
	179	54.000	2.240	31.250	-25.000	1.0378	69.88	1	62.500	31.250	0	0	0	0	0	0	0	0	0	0	0	;
	179	0.000	0.000	31.250	-25.000	1.0378	69.88	0	62.500	-62.500	0	0	0	0	0	0	0	0	0	0	0	;
	181	41.000	-0.649	22.000	-17.600	1.0281	49.19	1	44.000	22.000	0	0	0	0	0	0	0	0	0	0	0	;
	181	41.000	-0.649	22.000	-17.600	1.0281	49.19	1	44.000	22.000	0	0	0	0	0	0	0	0	0	0	0	;
	181	41.000	-0.649	22.000	-17.600	1.0281	49.19	1	44.000	22.000	0	0	0	0	0	0	0	0	0	0	0	;
	182	68.000	2.472	47.750	-38.200	1.0387	106.77	1	95.500	-95.500	0	0	0	0	0	0	0	0	0	0	0	;
	182	67.000	2.472	47.750	-38.200	1.0387	106.77	1	95.500	-95.500	0	0	0	0	0	0	0	0	0	0	0	;
	187	0.000	0.000	26.500	-21.200	1.0216	59.26	0	53.000	26.500	0	0	0	0	0	0	0	0	0	0	0	;
	188	0.000	0.000	26.500	-21.200	1.0216	59.26	0	53.000	26.500	0	0	0	0	0	0	0	0	0	0	0	;
	189	0.000	0.000	26.500	-21.200	1.0216	59.26	0	53.000	26.500	0	0	0	0	0	0	0	0	0	0	0	;
	191	60.000	-2.982	30.000	-24.000	1.0488	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	191	60.000	-2.982	30.000	-24.000	1.0488	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	191	60.000	-2.982	30.000	-24.000	1.0488	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	191	148.000	-9.393	94.500	-75.600	1.0488	211.31	1	189.000	94.500	0	0	0	0	0	0	0	0	0	0	0	;
	192	70.000	5.736	40.000	-32.000	1.0435	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	192	75.000	5.736	40.000	-32.000	1.0435	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	192	66.000	5.736	40.000	-32.000	1.0435	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	194	79.000	7.460	40.000	-32.000	1.0429	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	194	78.000	7.460	40.000	-32.000	1.0429	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	194	0.000	0.000	40.000	-32.000	1.0429	89.44	0	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	195	71.000	3.427	56.000	-44.800	1.0345	125.22	1	112.000	-112.000	0	0	0	0	0	0	0	0	0	0	0	;
	195	71.000	3.427	56.000	-44.800	1.0345	125.22	1	112.000	-112.000	0	0	0	0	0	0	0	0	0	0	0	;
	195	70.000	3.427	56.000	-44.800	1.0345	125.22	1	112.000	-112.000	0	0	0	0	0	0	0	0	0	0	0	;
	196	60.000	5.258	31.000	-24.800	1.0474	69.32	1	62.000	31.000	0	0	0	0	0	0	0	0	0	0	0	;
	196	60.000	5.258	31.000	-24.800	1.0474	69.32	1	62.000	31.000	0	0	0	0	0	0	0	0	0	0	0	;
	196	58.000	5.258	31.000	-24.800	1.0474	69.32	1	62.000	31.000	0	0	0	0	0	0	0	0	0	0	0	;
	198	75.000	-5.456	38.250	-30.600	1.0484	85.53	1	76.500	-76.500	0	0	0	0	0	0	0	0	0	0	0	;
	198	75.000	-5.456	38.250	-30.600	1.0484	85.53	1	76.500	-76.500	0	0	0	0	0	0	0	0	0	0	0	;
	200	60.000	-4.113	32.500	-26.000	1.0467	72.67	1	65.000	32.500	0	0	0	0	0	0	0	0	0	0	0	;
	201	60.000	-4.113	32.500	-26.000	1.0467	72.67	1	65.000	32.500	0	0	0	0	0	0	0	0	0	0	0	;
	202	58.000	-3.771	32.500	-26.000	1.0467	72.67	1	65.000	32.500	0	0	0	0	0	0	0	0	0	0	0	;
	203	228.000	3.688	122.500	-98.000	1.0468	273.92	1	245.000	122.500	0	0	0	0	0	0	0	0	0	0	0	;
	206	63.000	7.613	35.000	-28.000	1.0316	78.26	1	70.000	35.000	0	0	0	0	0	0	0	0	0	0	0	;
	207	63.000	6.340	35.000	-28.000	1.0316	78.26	1	70.000	35.000	0	0	0	0	0	0	0	0	0	0	0	;
	218	59.000	6.793	33.500	-26.800	1.0329	74.91	1	67.000	33.500	0	0	0	0	0	0	0	0	0	0	0	;
	218	60.000	6.793	33.500	-26.800	1.0329	74.91	1	67.000	33.500	0	0	0	0	0	0	0	0	0	0	0	;
	218	60.000	6.793	33.500	-26.800	1.0329	74.91	1	67.000	33.500	0	0	0	0	0	0	0	0	0	0	0	;
	222	287.000	37.232	235.200	-117.600	1.0258	457.15	1	392.000	235.200	0	0	0	0	0	0	0	0	0	0	0	;
	225	191.000	-32.719	95.500	-76.400	1.0487	213.54	1	191.000	95.500	0	0	0	0	0	0	0	0	0	0	0	;
	227	0.000	0.000	60.000	-48.000	1.0418	134.16	0	120.000	-120.000	0	0	0	0	0	0	0	0	0	0	0	;
	227	106.000	-27.786	60.000	-48.000	1.0418	134.16	1	120.000	-120.000	0	0	0	0	0	0	0	0	0	0	0	;
	228	104.000	-27.963	64.000	-51.200	1.0418	143.11	1	128.000	-128.000	0	0	0	0	0	0	0	0	0	0	0	;
	228	105.000	-27.963	64.000	-51.200	1.0418	143.11	1	128.000	-128.000	0	0	0	0	0	0	0	0	0	0	0	;
	229	0.000	0.000	195.000	-156.000	1.0440	436.03	0	390.000	-390.000	0	0	0	0	0	0	0	0	0	0	0	;
	229	0.000	0.000	195.000	-156.000	1.0440	436.03	0	390.000	-390.000	0	0	0	0	0	0	0	0	0	0	0	;
	230	123.000	31.543	110.000	-88.000	1.0446	245.97	1	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	231	129.000	-10.109	65.250	-52.200	1.0476	145.90	1	130.500	-130.500	0	0	0	0	0	0	0	0	0	0	0	;
	231	0.000	0.000	65.250	-52.200	1.0476	145.90	0	130.500	-130.500	0	0	0	0	0	0	0	0	0	0	0	;
	232	0.000	0.000	157.500	-126.000	1.0473	352.18	0	315.000	157.500	0	0	0	0	0	0	0	0	0	0	0	;
	233	271.000	30.207	157.500	-126.000	1.0473	352.18	1	315.000	157.500	0	0	0	0	0	0	0	0	0	0	0	;
	239	281.967	-53.221	235.200	-117.600	1.0431	457.15	1	392.000	235.200	0	0	0	0	0	0	0	0	0	0	0	;
	240	285.000	-7.438	235.200	-117.600	1.0431	457.15	1	392.000	235.200	0	0	0	0	0	0	0	0	0	0	0	;
	241	400.000	1.718	247.800	-123.900	1.0482	481.64	1	413.000	247.800	0	0	0	0	0	0	0	0	0	0	0	;
	242	400.000	13.095	247.800	-123.900	1.0482	481.64	1	413.000	247.800	0	0	0	0	0	0	0	0	0	0	0	;
	243	400.000	-47.771	251.100	-125.550	1.0469	488.05	1	418.500	251.100	0	0	0	0	0	0	0	0	0	0	0	;
	244	400.000	-35.842	251.100	-125.550	1.0469	488.05	1	418.500	251.100	0	0	0	0	0	0	0	0	0	0	0	;
	250	29.613	-4.472	19.787	-19.787	1.0368	53.28	1	49.466	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	251	4.143	2.068	68.439	-68.439	1.0291	184.28	1	171.098	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	252	5.640	-3.648	93.174	-93.174	1.0224	250.88	1	232.934	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	253	4.336	1.727	71.633	-71.633	1.0219	192.88	1	179.083	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	254	7.380	-0.844	121.919	-121.919	1.0323	328.28	1	304.798	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	255	114.321	-2.068	76.387	-76.387	1.0383	205.68	1	190.966	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	262	6.942	1.516	114.677	-114.677	1.0315	308.78	1	286.693	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	263	4.570	-5.731	75.496	-75.496	1.0308	203.28	1	188.739	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	264	7.765	2.236	128.270	-128.270	1.0305	345.38	1	320.675	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	265	4.039	14.034	66.731	-66.731	1.0311	179.68	1	166.827	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	266	4.727	-21.952	78.095	-78.095	1.0312	210.28	1	195.238	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	267	5.627	6.040	92.951	-92.951	1.0321	250.28	1	232.377	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	268	5.096	15.386	84.186	-84.186	1.0466	226.68	1	210.465	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	273	31.000	3.327	19.500	-15.600	1.0311	43.60	1	39.000	19.500	0	0	0	0	0	0	0	0	0	0	0	;
	273	30.000	3.327	19.500	-15.600	1.0311	43.60	1	39.000	19.500	0	0	0	0	0	0	0	0	0	0	0	;
	273	32.000	3.327	19.500	-15.600	1.0311	43.60	1	39.000	19.500	0	0	0	0	0	0	0	0	0	0	0	;
	293	176.800	-13.968	104.000	-104.000	1.0424	280.03	1	260.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	293	6.691	0.000	0.000	0.000	1.0424	70.00	1	70.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	309	0.000	0.000	78.530	-78.530	1.0324	211.45	0	196.325	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	311	153.000	13.608	138.750	-111.000	1.0471	310.25	1	277.500	-277.500	0	0	0	0	0	0	0	0	0	0	0	;
	311	0.000	0.000	138.750	-111.000	1.0471	310.25	0	277.500	-277.500	0	0	0	0	0	0	0	0	0	0	0	;
	313	0.000	0.000	94.236	-94.236	1.0485	253.74	0	235.590	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	314	0.000	0.000	109.063	-109.063	1.0376	293.66	0	272.658	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	315	0.000	0.000	62.824	-62.824	1.0475	169.16	0	157.060	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	316	0.000	0.000	94.236	-94.236	1.0487	253.74	0	235.590	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	40.000	-4.032	28.500	-22.800	1.0490	63.73	1	57.000	28.500	0	0	0	0	0	0	0	0	0	0	0	;
	317	0.000	0.000	28.500	-22.800	1.0490	63.73	0	57.000	28.500	0	0	0	0	0	0	0	0	0	0	0	;
	317	191.000	-15.562	110.000	-88.000	1.0490	245.97	1	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	191.000	-15.562	110.000	-88.000	1.0490	245.97	1	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	0.000	0.000	110.000	-88.000	1.0490	245.97	0	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	0.000	0.000	110.000	-88.000	1.0490	245.97	0	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	49.000	-5.659	40.000	-32.000	1.0490	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	0.000	0.000	40.000	-32.000	1.0490	89.44	0	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	319	0.966	5.697	15.965	-15.965	1.0314	42.99	1	39.914	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	320	0.000	0.000	39.727	-39.727	1.0303	106.97	0	99.317	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	321	0.000	0.000	21.988	-21.988	1.0251	59.21	0	54.971	0.000	0	0	0	0	0	0	0	0	0	0	0	;
];

%% gen tags 
% Generation Technology Type:
%  CWS (Connection with Spain),
%  FOG (Fossil Gas),
%  FHC (Fossil Hard Coal),
%  HWR (Hydro Water Reservoir),
%  HPS (Hydro Pumped Storage),
%  HRP (Hydro Run-of-river and poundage),
%  SH1 (Small Hydro - P ≤ 10 MW),
%  SH3 (Small Hydro - 10 MW < P ≤ 30 MW),
%  PVP (Photovoltaic power plant),
%  WON (Wind onshore),
%  WOF (Wind offshore),
%  MAR (Marine),
%  OTH (Other thermal, such as geothermal, biomass, biogas, Municipal solid waste and CHP renewable and non-renewable)
%	genType
mpc.gen_tags = {
	'CWS';	'CWS';	'CWS';	'CWS';	'CWS';	'CWS';	'CWS';	'CWS';	'PVP';	'PVP';	'PVP';	'PVP';	'PVP';	'PVP';	'HWR';	'HWR';	'PVP';	'HRP';	'HRP';	'HRP';	'PVP';	'WON';	'WON';	'PVP';	'PVP';	'WON';	'SH3';	'HRP';	'HRP';	'OTH';	'WON';	'SH1';	'PVP';	'OTH';	'PVP';	'OTH';	'OTH';	'PVP';	'OTH';	'SH1';	'PVP';	'OTH';	'WON';	'SH1';	'SH3';	'PVP';	'HPS';	'HPS';	'OTH';	'WON';	'SH1';	'OTH';	'SH1';	'PVP';	'OTH';	'PVP';	'OTH';	'WON';	'SH1';	'SH3';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'PVP';	'WON';	'SH1';	'PVP';	'OTH';	'WON';	'PVP';	'OTH';	'PVP';	'OTH';	'WON';	'SH1';	'WON';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'SH3';	'PVP';	'OTH';	'WON';	'SH1';	'PVP';	'HWR';	'OTH';	'WON';	'SH1';	'OTH';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'OTH';	'PVP';	'WON';	'OTH';	'PVP';	'OTH';	'WON';	'SH1';	'OTH';	'SH1';	'PVP';	'OTH';	'PVP';	'SH1';	'PVP';	'OTH';	'PVP';	'OTH';	'WON';	'SH1';	'PVP';	'OTH';	'WON';	'OTH';	'WON';	'PVP';	'OTH';	'PVP';	'OTH';	'PVP';	'HWR';	'HRP';	'HRP';	'HRP';	'HRP';	'HWR';	'HWR';	'OTH';	'WON';	'SH1';	'PVP';	'OTH';	'SH1';	'PVP';	'OTH';	'WON';	'SH1';	'SH3';	'PVP';	'WON';	'PVP';	'OTH';	'PVP';	'HWR';	'OTH';	'WON';	'SH1';	'WON';	'SH1';	'OTH';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'PVP';	'OTH';	'WON';	'SH1';	'WON';	'OTH';	'WON';	'SH1';	'WON';	'SH1';	'SH1';	'PVP';	'WON';	'SH1';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'OTH';	'PVP';	'WON';	'PVP';	'WON';	'SH1';	'SH1';	'PVP';	'WON';	'SH1';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HPS';	'HPS';	'HWR';	'HWR';	'HWR';	'HPS';	'HRP';	'HRP';	'HRP';	'HPS';	'HPS';	'HWR';	'HWR';	'HWR';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HPS';	'HPS';	'HPS';	'HRP';	'HRP';	'HRP';	'HPS';	'HPS';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'FOG';	'HRP';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HWR';	'HWR';	'FOG';	'FOG';	'FOG';	'FOG';	'FOG';	'FOG';	'OTH';	'WON';	'WON';	'WON';	'WON';	'OTH';	'WON';	'WON';	'WON';	'WON';	'WON';	'WON';	'WON';	'HRP';	'HRP';	'HRP';	'WOF';	'MAR';	'PVP';	'HPS';	'HPS';	'PVP';	'PVP';	'PVP';	'PVP';	'HWR';	'HWR';	'HPS';	'HPS';	'HPS';	'HPS';	'HWR';	'HWR';	'WON';	'PVP';	'PVP';
};

%% branch data
% If the 'step_size', 'actTap', 'minTap', 'maxTap' and 'normalTap' fields are equal to "-1", it means that the transformer does not have tap changing capability
% If the length is equal to "0", it means that the correspondent branch represents a transformer
%	fbus	tbus	r	x	b	rateA (summer)	rateB (spring)	rateC (winter)	tap ratio	shift angle		status	angmin	angmax	step_size	actTap	minTap	maxTap	normalTap	length (km)
mpc.branch = [
	8	24	0.02945	0.09879	0.03302	91	123	130	0	0	0	-360	360	0	0	0	0	0	54.0	;
	8	176	0.02007	0.06867	0.02205	96	104	104	0	0	1	-360	360	0	0	0	0	0	36.6	;
	8	176	0.02014	0.06872	0.02229	96	104	104	0	0	1	-360	360	0	0	0	0	0	36.7	;
	9	14	0.00146	0.00787	0.00265	255	260	260	0	0	1	-360	360	0	0	0	0	0	4.3	;
	9	14	0.00146	0.00769	0.00260	255	260	260	0	0	1	-360	360	0	0	0	0	0	4.2	;
	9	14	0.00137	0.00737	0.00250	124	162	203	0	0	1	-360	360	0	0	0	0	0	4.1	;
	10	19	0.02098	0.11168	0.03801	218	248	260	0	0	1	-360	360	0	0	0	0	0	61.3	;
	10	22	0.02445	0.08166	0.02747	164	186	206	0	0	1	-360	360	0	0	0	0	0	44.5	;
	10	26	0.00777	0.04761	0.01640	260	260	260	0	0	1	-360	360	0	0	0	0	0	26.0	;
	11	14	0.02030	0.07019	0.02214	171	186	206	0	0	1	-360	360	0	0	0	0	0	36.7	;
	11	14	0.02010	0.06862	0.02204	191	204	222	0	0	1	-360	360	0	0	0	0	0	36.5	;
	12	22	0.02823	0.10553	0.04049	189	204	222	0	0	1	-360	360	0	0	0	0	0	61.6	;
	12	23	0.01953	0.08771	0.03214	195	204	222	0	0	1	-360	360	0	0	0	0	0	49.8	;
	12	29	0.01515	0.04945	0.01745	195	204	222	0	0	1	-360	360	0	0	0	0	0	27.9	;
	12	29	0.01515	0.04945	0.01745	195	204	222	0	0	1	-360	360	0	0	0	0	0	27.9	;
	12	29	0.00551	0.05765	0.03609	260	260	260	0	0	1	-360	360	0	0	0	0	0	42.8	;
	12	34	0.02334	0.12013	0.04435	255	260	260	0	0	1	-360	360	0	0	0	0	0	68.7	;
	13	14	0.00788	0.04049	0.01506	255	260	260	0	0	1	-360	360	0	0	0	0	0	23.1	;
	13	14	0.00788	0.04049	0.01506	255	260	260	0	0	1	-360	360	0	0	0	0	0	23.1	;
	13	20	0.00745	0.02441	0.00855	195	204	221	0	0	1	-360	360	0	0	0	0	0	13.6	;
	13	20	0.00745	0.02441	0.00855	195	204	221	0	0	1	-360	360	0	0	0	0	0	13.6	;
	13	20	0.00745	0.02441	0.00855	195	204	221	0	0	1	-360	360	0	0	0	0	0	13.6	;
	13	20	0.00745	0.02441	0.00855	195	204	221	0	0	1	-360	360	0	0	0	0	0	13.6	;
	13	180	0.00411	0.02110	0.00788	255	260	260	0	0	1	-360	360	0	0	0	0	0	12.0	;
	13	246	0.00422	0.02163	0.00811	260	260	260	0	0	1	-360	360	0	0	0	0	0	12.2	;
	14	180	0.00411	0.02110	0.00788	255	260	260	0	0	1	-360	360	0	0	0	0	0	12.0	;
	14	185	0.01114	0.03788	0.01266	191	204	222	0	0	1	-360	360	0	0	0	0	0	20.5	;
	14	186	0.02662	0.09054	0.02905	185	204	222	0	0	1	-360	360	0	0	0	0	0	48.4	;
	14	246	0.00408	0.02092	0.00779	255	260	260	0	0	1	-360	360	0	0	0	0	0	12.0	;
	15	22	0.02154	0.10932	0.04126	224	248	260	0	0	1	-360	360	0	0	0	0	0	63.4	;
	15	22	0.02154	0.10932	0.04126	224	248	260	0	0	1	-360	360	0	0	0	0	0	63.4	;
	15	26	0.00974	0.05968	0.02055	260	260	260	0	0	1	-360	360	0	0	0	0	0	32.6	;
	15	27	0.02701	0.09576	0.03037	191	204	222	0	0	1	-360	360	0	0	0	0	0	50.5	;
	15	28	0.03335	0.10915	0.03827	195	204	222	0	0	1	-360	360	0	0	0	0	0	60.7	;
	15	29	0.05251	0.17172	0.06032	195	204	222	0	0	1	-360	360	0	0	0	0	0	95.6	;
	15	250	0.00184	0.00954	0.00342	130	130	130	0	0	1	-360	360	0	0	0	0	0	5.4	;
	15	250	0.00187	0.00974	0.00349	130	130	130	0	0	1	-360	360	0	0	0	0	0	5.5	;
	15	255	0.00282	0.01157	0.02727	260	273	296	0	0	1	-360	360	0	0	0	0	0	5.9	;
	16	178	0.00839	0.03586	0.01167	104	123	130	0	0	1	-360	360	0	0	0	0	0	19.0	;
	17	21	0.01658	0.06789	0.02323	195	204	222	0	0	1	-360	360	0	0	0	0	0	37.9	;
	17	21	0.00900	0.05720	0.02480	260	273	296	0	0	1	-360	360	0	0	0	0	0	35.0	;
	17	25	0.01638	0.06453	0.02191	104	123	153	0	0	1	-360	360	0	0	0	0	0	35.2	;
	17	184	0.01106	0.03018	0.01032	91	108	134	0	0	1	-360	360	0	0	0	0	0	16.6	;
	18	287	0.00156	0.01068	0.00498	260	273	296	0	0	0	-360	360	0	0	0	0	0	6.8	;
	18	288	0.00151	0.01038	0.00484	260	273	296	0	0	1	-360	360	0	0	0	0	0	6.6	;
	18	306	0.00548	0.02813	0.01051	255	260	260	0	0	1	-360	360	0	0	0	0	0	16.0	;
	18	307	0.00480	0.02461	0.00920	255	260	260	0	0	1	-360	360	0	0	0	0	0	14.0	;
	19	186	0.02662	0.09054	0.02905	185	204	222	0	0	1	-360	360	0	0	0	0	0	48.4	;
	21	30	0.01441	0.06067	0.02080	195	204	222	0	0	1	-360	360	0	0	0	0	0	33.3	;
	21	32	0.00720	0.04579	0.01985	260	273	296	0	0	1	-360	360	0	0	0	0	0	28.0	;
	21	32	0.00720	0.04579	0.01985	260	273	296	0	0	1	-360	360	0	0	0	0	0	28.0	;
	21	251	0.00610	0.04180	0.01950	260	273	296	0	0	1	-360	360	0	0	0	0	0	26.5	;
	22	34	0.01325	0.06238	0.06238	337	372	411	0	0	1	-360	360	0	0	0	0	0	57.9	;
	22	245	0.01212	0.04116	0.01324	81	123	130	0	0	1	-360	360	0	0	0	0	0	22.0	;
	23	34	0.01185	0.06135	0.02247	255	260	260	0	0	1	-360	360	0	0	0	0	0	35.1	;
	23	34	0.01185	0.06135	0.02247	255	260	260	0	0	1	-360	360	0	0	0	0	0	35.1	;
	23	34	0.01580	0.07475	0.02730	255	260	260	0	0	1	-360	360	0	0	0	0	0	42.7	;
	24	31	0.00310	0.03271	0.07540	520	520	520	0	0	1	-360	360	0	0	0	0	0	46.5	;
	24	181	0.00436	0.01464	0.00484	189	195	195	0	0	1	-360	360	0	0	0	0	0	7.8	;
	24	248	0.00715	0.03705	0.01350	227	248	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	24	248	0.00715	0.03705	0.01350	227	248	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	24	252	0.01240	0.06509	0.02314	253	260	260	0	0	1	-360	360	0	0	0	0	0	36.3	;
	25	32	0.01065	0.03476	0.01219	195	204	222	0	0	1	-360	360	0	0	0	0	0	19.3	;
	25	32	0.01069	0.03488	0.01223	195	204	222	0	0	1	-360	360	0	0	0	0	0	19.3	;
	25	32	0.00504	0.02690	0.01516	233	248	260	0	0	1	-360	360	0	0	0	0	0	18.0	;
	25	307	0.00582	0.01853	0.00675	104	123	153	0	0	1	-360	360	0	0	0	0	0	10.6	;
	25	307	0.00581	0.01846	0.00677	104	123	153	0	0	1	-360	360	0	0	0	0	0	10.6	;
	27	185	0.01114	0.03788	0.01266	191	204	222	0	0	1	-360	360	0	0	0	0	0	20.5	;
	28	29	0.01921	0.06275	0.02210	195	204	222	0	0	1	-360	360	0	0	0	0	0	35.2	;
	30	32	0.00729	0.02383	0.00834	195	204	222	0	0	1	-360	360	0	0	0	0	0	13.2	;
	30	32	0.00729	0.02383	0.00834	195	204	222	0	0	1	-360	360	0	0	0	0	0	13.2	;
	30	32	0.00732	0.02829	0.00946	195	204	222	0	0	1	-360	360	0	0	0	0	0	15.4	;
	30	33	0.00260	0.02724	0.01640	520	520	520	0	0	1	-360	360	0	0	0	0	0	19.8	;
	30	174	0.00358	0.02407	0.00900	260	260	260	0	0	1	-360	360	0	0	0	0	0	13.8	;
	30	179	0.00403	0.01370	0.00440	104	123	153	0	0	1	-360	360	0	0	0	0	0	7.3	;
	30	184	0.01106	0.03018	0.01032	91	108	134	0	0	1	-360	360	0	0	0	0	0	16.6	;
	31	248	0.00715	0.03705	0.01350	227	248	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	31	248	0.00715	0.03705	0.01350	227	248	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	31	253	0.01091	0.05722	0.02036	253	260	260	0	0	1	-360	360	0	0	0	0	0	31.9	;
	32	33	0.00695	0.04818	0.02461	504	520	520	0	0	1	-360	360	0	0	0	0	0	32.2	;
	32	254	0.01869	0.10188	0.03320	260	273	296	0	0	1	-360	360	0	0	0	0	0	53.5	;
	32	254	0.01869	0.10188	0.03320	260	273	296	0	0	1	-360	360	0	0	0	0	0	53.5	;
	32	306	0.01351	0.04810	0.01561	195	204	222	0	0	1	-360	360	0	0	0	0	0	25.7	;
	33	173	0.00082	0.00526	0.00200	306	321	348	0	0	1	-360	360	0	0	0	0	0	3.0	;
	33	177	0.00830	0.02880	0.00938	104	104	104	0	0	1	-360	360	0	0	0	0	0	15.3	;
	33	182	0.00023	0.00161	0.00056	306	321	348	0	0	1	-360	360	0	0	0	0	0	0.9	;
	33	184	0.00504	0.03382	0.01267	274	291	322	0	0	1	-360	360	0	0	0	0	0	19.3	;
	36	64	0.00418	0.02292	0.13770	999	1092	1206	0	0	1	-360	360	0	0	0	0	0	52.3	;
	36	71	0.00396	0.02133	0.13035	999	1092	1206	0	0	1	-360	360	0	0	0	0	0	48.9	;
	36	187	0.00011	0.00060	0.00094	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.7	;
	36	188	0.00018	0.00061	0.00092	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.7	;
	36	189	0.00018	0.00061	0.00092	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.8	;
	37	59	0.00168	0.00382	0.35975	493	493	493	0	0	1	-360	360	0	0	0	0	0	10.4	;
	37	213	0.00017	0.00044	0.04927	322	322	322	0	0	1	-360	360	0	0	0	0	0	1.8	;
	37	214	0.00017	0.00044	0.04927	322	322	322	0	0	1	-360	360	0	0	0	0	0	1.8	;
	37	215	0.00017	0.00044	0.04927	322	322	322	0	0	1	-360	360	0	0	0	0	0	1.8	;
	37	216	0.00017	0.00044	0.04927	322	322	322	0	0	1	-360	360	0	0	0	0	0	1.8	;
	38	208	0.00048	0.00109	0.10268	493	493	493	0	0	1	-360	360	0	0	0	0	0	3.2	;
	38	209	0.00048	0.00108	0.10056	493	493	493	0	0	1	-360	360	0	0	0	0	0	3.2	;
	39	45	0.01696	0.09185	0.14133	381	381	381	0	0	1	-360	360	0	0	0	0	0	106.8	;
	39	69	0.00691	0.03721	0.05799	513	546	571.5	0	0	1	-360	360	0	0	0	0	0	43.0	;
	39	69	0.00687	0.03725	0.05671	381	381	381	0	0	1	-360	360	0	0	0	0	0	43.0	;
	39	71	0.00183	0.01006	0.05957	1026	1090.5	1143	0	0	1	-360	360	0	0	0	0	0	22.2	;
	39	78	0.00658	0.03647	0.05332	382	400	435	0	0	1	-360	360	0	0	0	0	0	41.1	;
	39	195	0.00484	0.02634	0.04046	199	237	297	0	0	1	-360	360	0	0	0	0	0	30.4	;
	39	199	0.00873	0.04861	0.07070	381	381	381	0	0	1	-360	360	0	0	0	0	0	54.7	;
	39	258	0.00326	0.01810	0.02629	382	400	435	0	0	1	-360	360	0	0	0	0	0	20.3	;
	39	258	0.00240	0.01307	0.02007	199	237	297	0	0	1	-360	360	0	0	0	0	0	15.1	;
	40	51	0.00874	0.04843	0.07272	374	400	435	0	0	1	-360	360	0	0	0	0	0	54.7	;
	40	65	0.00985	0.05518	0.07982	499.5	546	571.5	0	0	1	-360	360	0	0	0	0	0	61.9	;
	40	65	0.00944	0.05439	0.07975	499.5	546	571.5	0	0	1	-360	360	0	0	0	0	0	61.8	;
	40	196	0.00017	0.00091	0.00135	182	237	297	0	0	1	-360	360	0	0	0	0	0	1.0	;
	40	198	0.00214	0.01565	0.02877	439	471	511	0	0	1	-360	360	0	0	0	0	0	19.6	;
	40	5	0.00630	0.03584	0.05497	374	400	435	0	0	1	-360	360	0	0	0	0	0	41.1	;
	40	5	0.00636	0.03628	0.05564	374	400	435	0	0	1	-360	360	0	0	0	0	0	41.4	;
	40	6	0.00481	0.02670	0.03939	360	390	430	0	0	1	-360	360	0	0	0	0	0	30.2	;
	41	53	0.00145	0.00845	0.01465	381	381	381	0	0	1	-360	360	0	0	0	0	0	10.4	;
	41	53	0.00078	0.00546	0.00902	381	381	381	0	0	1	-360	360	0	0	0	0	0	6.5	;
	41	57	0.00318	0.01660	0.02798	381	381	381	0	0	1	-360	360	0	0	0	0	0	20.2	;
	41	68	0.00084	0.00572	0.00995	401	426	472	0	0	1	-360	360	0	0	0	0	0	7.0	;
	41	68	0.00170	0.00386	0.36133	493	493	493	0	0	1	-360	360	0	0	0	0	0	10.7	;
	41	210	0.00056	0.00586	0.01715	762	762	762	0	0	1	-360	360	0	0	0	0	0	9.4	;
	41	211	0.00221	0.02313	0.06702	762	762	762	0	0	1	-360	360	0	0	0	0	0	37.0	;
	41	308	0.00006	0.00025	0.01708	240	240	240	0	0	1	-360	360	0	0	0	0	0	0.7	;
	42	78	0.00448	0.02493	0.03617	382	400	435	0	0	1	-360	360	0	0	0	0	0	28.0	;
	42	78	0.00448	0.02494	0.03619	382	400	435	0	0	1	-360	360	0	0	0	0	0	28.0	;
	42	257	0.00276	0.01543	0.02230	381	381	381	0	0	1	-360	360	0	0	0	0	0	17.3	;
	42	257	0.00274	0.01524	0.02237	381	381	381	0	0	1	-360	360	0	0	0	0	0	17.3	;
	43	58	0.00210	0.00476	0.44633	493	493	493	0	0	1	-360	360	0	0	0	0	0	12.6	;
	43	76	0.00113	0.00321	0.34652	446	446	446	0	0	1	-360	360	0	0	0	0	0	11.1	;
	43	76	0.00113	0.00320	0.34511	446	446	446	0	0	1	-360	360	0	0	0	0	0	11.1	;
	43	204	0.00146	0.00771	0.01235	381	381	381	0	0	1	-360	360	0	0	0	0	0	9.2	;
	43	205	0.00063	0.00332	0.00533	381	381	381	0	0	1	-360	360	0	0	0	0	0	3.9	;
	43	219	0.00083	0.00445	0.00676	342	364	381	0	0	1	-360	360	0	0	0	0	0	5.4	;
	44	48	0.00396	0.02139	0.03311	342	364	381	0	0	1	-360	360	0	0	0	0	0	24.9	;
	44	66	0.00779	0.04029	0.06834	381	381	381	0	0	1	-360	360	0	0	0	0	0	50.9	;
	44	66	0.00311	0.03080	0.09461	897	941	1021	0	0	1	-360	360	0	0	0	0	0	50.7	;
	44	193	0.00504	0.02686	0.04234	381	381	381	0	0	1	-360	360	0	0	0	0	0	31.7	;
	45	46	0.00650	0.03510	0.05270	382	400	435	0	0	1	-360	360	0	0	0	0	0	40.2	;
	45	46	0.00608	0.03139	0.05420	382	400	435	0	0	1	-360	360	0	0	0	0	0	38.8	;
	45	46	0.00614	0.03155	0.05417	382	400	435	0	0	1	-360	360	0	0	0	0	0	38.8	;
	45	74	0.00586	0.03263	0.04775	381	381	381	0	0	1	-360	360	0	0	0	0	0	36.7	;
	45	74	0.00586	0.03263	0.04775	381	381	381	0	0	1	-360	360	0	0	0	0	0	36.7	;
	45	199	0.00873	0.04861	0.07070	381	381	381	0	0	1	-360	360	0	0	0	0	0	54.7	;
	46	50	0.00409	0.02221	0.03328	381	400	435	0	0	1	-360	360	0	0	0	0	0	25.4	;
	46	64	0.00275	0.01510	0.09065	666	728	804	0	0	1	-360	360	0	0	0	0	0	34.8	;
	46	214	0.00477	0.02559	0.04001	381	381	381	0	0	1	-360	360	0	0	0	0	0	30.0	;
	46	216	0.00465	0.02524	0.03797	382	400	435	0	0	1	-360	360	0	0	0	0	0	28.9	;
	46	222	0.00006	0.00021	0.02068	438	438	438	0	0	1	-360	360	0	0	0	0	0	0.8	;
	46	260	0.00913	0.04888	0.07531	342	364	381	0	0	1	-360	360	0	0	0	0	0	56.8	;
	47	57	0.01028	0.05388	0.08954	381	381	381	0	0	1	-360	360	0	0	0	0	0	65.0	;
	47	61	0.00034	0.00182	0.00285	199	237	297	0	0	1	-360	360	0	0	0	0	0	2.1	;
	47	66	0.00525	0.02886	0.04430	381	381	381	0	0	1	-360	360	0	0	0	0	0	33.4	;
	47	67	0.00789	0.04153	0.06856	381	381	381	0	0	1	-360	360	0	0	0	0	0	50.0	;
	47	75	0.00724	0.03931	0.05957	382	400	435	0	0	1	-360	360	0	0	0	0	0	45.0	;
	47	211	0.00221	0.02313	0.06702	762	762	762	0	0	1	-360	360	0	0	0	0	0	37.0	;
	47	224	0.00039	0.00426	0.01070	750	762	762	0	0	1	-360	360	0	0	0	0	0	6.4	;
	48	66	0.01101	0.05739	0.09535	381	381	381	0	0	1	-360	360	0	0	0	0	0	69.5	;
	48	69	0.00352	0.01887	0.02971	513	546	571.5	0	0	1	-360	360	0	0	0	0	0	22.6	;
	48	69	0.00350	0.01889	0.02900	381	381	381	0	0	1	-360	360	0	0	0	0	0	22.0	;
	49	57	0.00169	0.00872	0.05960	381	381	381	0	0	1	-360	360	0	0	0	0	0	21.4	;
	49	193	0.00037	0.00490	0.01932	1200	1200	1200	0	0	1	-360	360	0	0	0	0	0	9.2	;
	49	221	0.00055	0.00728	0.02882	762	762	762	0	0	1	-360	360	0	0	0	0	0	13.7	;
	50	55	0.00311	0.01663	0.02615	381	381	381	0	0	1	-360	360	0	0	0	0	0	19.5	;
	50	55	0.00252	0.01377	0.02062	381	381	381	0	0	1	-360	360	0	0	0	0	0	15.8	;
	50	56	0.00162	0.01419	0.06090	762	762	762	0	0	1	-360	360	0	0	0	0	0	27.0	;
	50	204	0.00146	0.00771	0.01235	381	381	381	0	0	1	-360	360	0	0	0	0	0	9.2	;
	50	213	0.00210	0.01087	0.01848	381	381	381	0	0	1	-360	360	0	0	0	0	0	13.3	;
	50	215	0.00316	0.01718	0.02582	382	400	435	0	0	1	-360	360	0	0	0	0	0	19.7	;
	50	217	0.00182	0.00952	0.01558	382	400	435	0	0	1	-360	360	0	0	0	0	0	11.3	;
	51	66	0.00711	0.03753	0.06399	382	400	435	0	0	1	-360	360	0	0	0	0	0	45.9	;
	51	66	0.00712	0.03759	0.06408	382	400	435	0	0	1	-360	360	0	0	0	0	0	46.0	;
	51	194	0.00465	0.02422	0.04046	382	400	435	0	0	1	-360	360	0	0	0	0	0	29.4	;
	51	194	0.00466	0.02427	0.04055	382	400	435	0	0	1	-360	360	0	0	0	0	0	29.5	;
	51	224	0.00039	0.00426	0.01070	750	762	762	0	0	0	-360	360	0	0	0	0	0	6.4	;
	52	199	0.00057	0.00311	0.00469	191	191	191	0	0	1	-360	360	0	0	0	0	0	3.6	;
	53	68	0.00078	0.00545	0.00900	401	426	472	0	0	1	-360	360	0	0	0	0	0	6.6	;
	53	190	0.00222	0.01196	0.02035	381	381	381	0	0	1	-360	360	0	0	0	0	0	14.7	;
	54	63	0.00412	0.02158	0.03520	374	381	381	0	0	1	-360	360	0	0	0	0	0	25.7	;
	54	77	0.00631	0.03514	0.05182	374	400	435	0	0	1	-360	360	0	0	0	0	0	39.5	;
	54	77	0.00636	0.03898	0.06249	374	400	435	0	0	1	-360	360	0	0	0	0	0	46.1	;
	54	191	0.00237	0.01312	0.01925	182	229	229	0	0	1	-360	360	0	0	0	0	0	14.9	;
	54	191	0.00189	0.01296	0.02104	229	229	229	0	0	1	-360	360	0	0	0	0	0	15.5	;
	54	192	0.00309	0.01722	0.02516	374	400	435	0	0	1	-360	360	0	0	0	0	0	19.4	;
	54	200	0.00006	0.00035	0.00053	182	237	297	0	0	1	-360	360	0	0	0	0	0	0.4	;
	54	201	0.00006	0.00035	0.00053	182	237	297	0	0	1	-360	360	0	0	0	0	0	0.4	;
	54	202	0.00006	0.00035	0.00053	182	237	297	0	0	1	-360	360	0	0	0	0	0	0.4	;
	54	203	0.00005	0.00034	0.00053	182	237	297	0	0	1	-360	360	0	0	0	0	0	0.2	;
	55	58	0.00049	0.00177	0.22418	364	364	364	0	0	1	-360	360	0	0	0	0	0	7.8	;
	55	204	0.00041	0.00224	0.00340	381	381	381	0	0	1	-360	360	0	0	0	0	0	2.6	;
	55	205	0.00063	0.00332	0.00533	381	381	381	0	0	1	-360	360	0	0	0	0	0	3.9	;
	56	74	0.00719	0.04008	0.05857	382	400	435	0	0	1	-360	360	0	0	0	0	0	46.0	;
	56	205	0.00144	0.00779	0.01170	382	400	435	0	0	1	-360	360	0	0	0	0	0	8.9	;
	57	60	0.00351	0.01764	0.02842	381	381	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	57	67	0.00249	0.01299	0.02177	381	381	381	0	0	1	-360	360	0	0	0	0	0	15.7	;
	57	190	0.00222	0.01196	0.02035	381	381	381	0	0	1	-360	360	0	0	0	0	0	14.7	;
	57	210	0.00056	0.00586	0.01715	762	762	762	0	0	1	-360	360	0	0	0	0	0	9.4	;
	57	220	0.00042	0.00563	0.02152	1200	1200	1200	0	0	1	-360	360	0	0	0	0	0	10.4	;
	57	221	0.00055	0.00728	0.02882	762	762	762	0	0	1	-360	360	0	0	0	0	0	13.7	;
	58	219	0.00038	0.00138	0.17477	364	364	364	0	0	1	-360	360	0	0	0	0	0	6.2	;
	59	217	0.00204	0.00462	0.43235	493	493	493	0	0	1	-360	360	0	0	0	0	0	12.5	;
	60	66	0.00204	0.01097	0.01708	381	381	381	0	0	1	-360	360	0	0	0	0	0	12.8	;
	60	206	0.00004	0.00020	0.00031	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.2	;
	60	207	0.00004	0.00024	0.00036	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.3	;
	62	259	0.00494	0.02909	0.05136	376	381	381	0	0	1	-360	360	0	0	0	0	0	36.5	;
	62	259	0.00494	0.02910	0.05138	376	381	381	0	0	1	-360	360	0	0	0	0	0	36.5	;
	62	261	0.00436	0.02258	0.03816	370	381	381	0	0	1	-360	360	0	0	0	0	0	27.5	;
	62	309	0.00099	0.00511	0.00864	370	381	381	0	0	1	-360	360	0	0	0	0	0	6.2	;
	62	309	0.00100	0.00533	0.00832	374	381	381	0	0	1	-360	360	0	0	0	0	0	6.2	;
	63	194	0.01182	0.06597	0.09589	374	381	381	0	0	1	-360	360	0	0	0	0	0	74.1	;
	65	257	0.00276	0.01543	0.02230	381	381	381	0	0	1	-360	360	0	0	0	0	0	17.3	;
	65	257	0.00274	0.01524	0.02237	381	381	381	0	0	1	-360	360	0	0	0	0	0	17.3	;
	65	259	0.00494	0.02909	0.05136	376	381	381	0	0	1	-360	360	0	0	0	0	0	36.5	;
	65	259	0.00494	0.02910	0.05138	376	381	381	0	0	1	-360	360	0	0	0	0	0	36.5	;
	66	75	0.00643	0.07053	0.19964	762	762	762	0	0	1	-360	360	0	0	0	0	0	111.0	;
	66	218	0.00004	0.00024	0.00036	381	381	381	0	0	1	-360	360	0	0	0	0	0	0.3	;
	71	78	0.01059	0.05809	0.08706	382	400	435	0	0	1	-360	360	0	0	0	0	0	66.3	;
	71	78	0.01059	0.05809	0.08706	382	400	435	0	0	1	-360	360	0	0	0	0	0	66.3	;
	72	261	0.00436	0.02258	0.03816	370	381	381	0	0	1	-360	360	0	0	0	0	0	27.5	;
	72	261	0.00436	0.02258	0.03816	370	381	381	0	0	1	-360	360	0	0	0	0	0	27.5	;
	73	77	0.00728	0.03932	0.06050	374	400	435	0	0	1	-360	360	0	0	0	0	0	45.6	;
	73	77	0.00728	0.03932	0.06050	374	400	435	0	0	1	-360	360	0	0	0	0	0	45.6	;
	73	79	0.00323	0.03461	0.09262	762	762	762	0	0	1	-360	360	0	0	0	0	0	52.6	;
	75	79	0.00198	0.02173	0.06151	762	762	762	0	0	1	-360	360	0	0	0	0	0	34.2	;
	75	267	0.00007	0.00037	0.00060	382	400	435	0	0	1	-360	360	0	0	0	0	0	0.4	;
	77	192	0.00417	0.02316	0.03385	374	400	435	0	0	1	-360	360	0	0	0	0	0	26.1	;
	77	192	0.00415	0.02295	0.03391	374	400	435	0	0	1	-360	360	0	0	0	0	0	26.2	;
	78	223	0.00210	0.01129	0.01767	342	364	402	0	0	1	-360	360	0	0	0	0	0	13.2	;
	78	258	0.00326	0.01810	0.02629	382	400	435	0	0	1	-360	360	0	0	0	0	0	20.3	;
	80	87	0.00110	0.01238	0.32679	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	59.4	;
	80	105	0.00121	0.01319	0.34995	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	64.1	;
	80	314	0.00084	0.00916	0.24295	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	44.5	;
	80	315	0.00189	0.02058	0.54594	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	100.0	;
	81	93	0.00033	0.00354	0.11277	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	18.9	;
	81	94	0.00067	0.00698	0.22053	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	37.0	;
	82	85	0.00129	0.01423	0.39181	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	69.3	;
	82	89	0.00033	0.00337	0.11050	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	18.3	;
	82	100	0.00073	0.00767	0.23726	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	40.2	;
	83	85	0.00102	0.01121	0.31128	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	55.0	;
	83	95	0.00097	0.01070	0.29713	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	52.5	;
	83	99	0.00145	0.01359	0.36483	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	65.9	;
	83	100	0.00148	0.01682	0.44536	1363	1386	1386	0	0	1	-360	360	0	0	0	0	0	80.9	;
	83	101	0.00180	0.02068	0.54758	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	101.5	;
	84	86	0.00052	0.00545	0.17093	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	28.9	;
	84	100	0.00154	0.01688	0.47566	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	83.9	;
	85	89	0.00155	0.01781	0.47277	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	86.0	;
	85	95	0.00156	0.01787	0.47431	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	86.3	;
	85	99	0.00155	0.01683	0.44571	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	81.2	;
	86	87	0.00177	0.01995	0.52618	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	96.0	;
	86	97	0.00029	0.00326	0.08819	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	15.9	;
	86	226	0.00087	0.01001	0.27166	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	48.1	;
	87	102	0.00188	0.01980	0.56096	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	97.8	;
	87	226	0.00087	0.01001	0.27166	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	48.1	;
	88	93	0.00054	0.00612	0.16169	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	29.4	;
	88	93	0.00060	0.00719	0.18512	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	34.1	;
	88	96	0.00110	0.01246	0.32750	1631	1711	1856	0	0	1	-360	360	0	0	0	0	0	59.6	;
	88	104	0.00039	0.00442	0.11663	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	21.2	;
	89	97	0.00098	0.01097	0.30363	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	53.6	;
	89	100	0.00045	0.00479	0.14279	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	24.6	;
	89	226	0.00172	0.01783	0.57194	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	94.6	;
	89	315	0.00152	0.01616	0.48177	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	83.0	;
	89	315	0.00152	0.01616	0.48177	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	83.0	;
	90	93	0.00140	0.01450	0.44012	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	74.8	;
	90	103	0.00130	0.01145	0.38503	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	61.9	;
	90	103	0.00130	0.01145	0.38503	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	61.9	;
	90	268	0.00029	0.00313	0.08865	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	15.4	;
	90	310	0.00081	0.00883	0.24845	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	43.8	;
	90	311	0.00022	0.00248	0.06641	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	12.0	;
	91	104	0.00058	0.00534	0.23072	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	33.0	;
	91	104	0.00055	0.00578	0.21834	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	33.5	;
	91	229	0.00006	0.00064	0.01773	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	3.2	;
	91	229	0.00003	0.00034	0.00976	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	3.1	;
	91	230	0.00012	0.00131	0.03755	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	6.6	;
	92	93	0.00042	0.00475	0.12571	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	23.3	;
	92	95	0.00203	0.02300	0.61990	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	111.8	;
	92	317	0.00183	0.02078	0.56002	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	101.0	;
	92	317	0.00183	0.02078	0.56002	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	101.0	;
	93	94	0.00083	0.00877	0.26932	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	46.4	;
	93	101	0.00154	0.01769	0.46841	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	85.3	;
	94	312	0.00091	0.00943	0.29801	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	50.0	;
	95	101	0.00118	0.01226	0.38323	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	63.7	;
	95	241	0.00023	0.00238	0.07551	528	528	528	0	0	1	-360	360	0	0	0	0	0	12.7	;
	95	242	0.00018	0.00203	0.05599	528	528	528	0	0	1	-360	360	0	0	0	0	0	9.9	;
	96	104	0.00073	0.00817	0.21485	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	39.1	;
	96	232	0.00000	0.00009	0.00247	350	350	350	0	0	1	-360	360	0	0	0	0	0	0.4	;
	96	233	0.00000	0.00008	0.00236	350	350	350	0	0	1	-360	360	0	0	0	0	0	0.4	;
	96	1	0.00090	0.00952	0.28796	1390	1400	1660	0	0	1	-360	360	0	0	0	0	0	1.1	;
	96	1	0.00090	0.00952	0.28796	1390	1400	1660	0	0	1	-360	360	0	0	0	0	0	1.1	;
	98	99	0.00075	0.00843	0.22418	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	40.9	;
	98	316	0.00163	0.01830	0.48673	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	88.8	;
	98	318	0.00186	0.02092	0.55634	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	101.5	;
	98	3	0.00050	0.00560	0.14990	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	25.7	;
	99	243	0.00000	0.00003	0.00085	505	505	505	0	0	1	-360	360	0	0	0	0	0	0.2	;
	99	244	0.00000	0.00004	0.00112	505	505	505	0	0	1	-360	360	0	0	0	0	0	0.2	;
	99	313	0.00211	0.02370	0.63033	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	115.0	;
	100	239	0.00001	0.00006	0.00189	438	438	438	0	0	1	-360	360	0	0	0	0	0	0.3	;
	100	240	0.00000	0.00005	0.00147	438	438	438	0	0	1	-360	360	0	0	0	0	0	0.2	;
	101	103	0.00135	0.01243	0.34410	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	60.6	;
	101	103	0.00135	0.01243	0.34410	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	60.6	;
	102	107	0.00148	0.01558	0.48416	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	81.3	;
	104	312	0.00069	0.00733	0.22050	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	37.8	;
	105	227	0.00002	0.00025	0.00729	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	1.2	;
	105	228	0.00002	0.00016	0.00490	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	0.8	;
	105	313	0.00138	0.01546	0.41109	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	75.0	;
	105	4	0.00165	0.01585	0.47306	1280	1386	1386	0	0	1	-360	360	0	0	0	0	0	39.9	;
	106	225	0.00054	0.00576	0.17268	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	29.4	;
	106	310	0.00081	0.00883	0.24845	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	43.8	;
	106	317	0.00279	0.03061	0.86181	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	152.0	;
	106	2	0.00014	0.00127	0.03480	1469	1571	1706	0	0	1	-360	360	0	0	0	0	0	4.7	;
	107	314	0.00109	0.01191	0.31610	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	57.9	;
	107	7	0.00128	0.01156	0.34479	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	33.9	;
	115	269	0.04872	0.13047	0.00658	68.4	95.7	95.7	0	0	1	-360	360	0	0	0	0	0	27.1	;
	116	279	0.00140	0.00618	0.00007	141.9	148.1	148.1	0	0	1	-360	360	0	0	0	0	0	0.7	;
	130	280	0.00764	0.02567	0.00141	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	5.6	;
	130	280	0.00675	0.02267	0.00124	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	4.9	;
	132	283	0.00006	0.00038	0.00000	98.2	105.2	105.2	0	0	1	-360	360	0	0	0	0	0	0.0	;
	145	286	0.00039	0.00130	0.00007	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	0.3	;
	148	172	0.02098	0.07050	0.00097	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	7.6	;
	148	294	0.04434	0.11874	0.00150	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	12.4	;
	165	272	0.03544	0.11907	0.00163	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	12.9	;
	165	298	0.10947	0.36776	0.00504	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	39.8	;
	165	300	0.09382	0.31521	0.00432	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	34.1	;
	167	297	0.00700	0.01875	0.00024	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	2.0	;
	172	304	0.03250	0.10917	0.00150	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	11.8	;
	173	174	0.00209	0.01408	0.00522	274	291	322	0	0	1	-360	360	0	0	0	0	0	8.0	;
	175	176	0.00576	0.01966	0.00632	96	104	104	0	0	1	-360	360	0	0	0	0	0	10.5	;
	180	249	0.00173	0.00907	0.00310	136	162	203	0	0	1	-360	360	0	0	0	0	0	4.5	;
	185	247	0.00468	0.01573	0.00525	171	186	206	0	0	0	-360	360	0	0	0	0	0	8.5	;
	186	247	0.00382	0.01284	0.00428	171	186	206	0	0	1	-360	360	0	0	0	0	0	6.9	;
	190	256	0.00032	0.00165	0.00260	382	400	435	0	0	1	-360	360	0	0	0	0	0	1.9	;
	193	220	0.00037	0.00490	0.01932	1200	1200	1200	0	0	1	-360	360	0	0	0	0	0	9.2	;
	195	258	0.00240	0.01307	0.02007	199	237	297	0	0	1	-360	360	0	0	0	0	0	15.1	;
	208	210	0.00017	0.00165	0.00492	897	941	1021	0	0	1	-360	360	0	0	0	0	0	2.6	;
	209	211	0.00016	0.00164	0.00484	897	941	1021	0	0	1	-360	360	0	0	0	0	0	2.6	;
	212	263	0.00201	0.01066	0.01664	374	381	381	0	0	1	-360	360	0	0	0	0	0	12.5	;
	212	266	0.00001	0.00006	0.00010	374	400	435	0	0	1	-360	360	0	0	0	0	0	0.3	;
	212	309	0.00100	0.00533	0.00832	374	381	381	0	0	1	-360	360	0	0	0	0	0	6.2	;
	220	221	0.00003	0.00043	0.00171	1204	1279	1416	0	0	1	-360	360	0	0	0	0	0	0.8	;
	223	262	0.00210	0.01129	0.01767	342	364	402	0	0	1	-360	360	0	0	0	0	0	13.2	;
	223	265	0.00001	0.00007	0.00011	382	400	435	0	0	1	-360	360	0	0	0	0	0	0.1	;
	224	264	0.00058	0.00305	0.00481	382	400	435	0	0	1	-360	360	0	0	0	0	0	3.6	;
	231	311	0.00050	0.00576	0.15386	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	27.8	;
	261	309	0.00337	0.01746	0.02953	370	381	381	0	0	1	-360	360	0	0	0	0	0	21.3	;
	269	270	0.00018	0.00048	0.00002	68.4	95.7	95.7	0	0	1	-360	360	0	0	0	0	0	0.1	;
	270	271	0.03024	0.10158	0.00139	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	11.0	;
	271	272	0.06361	0.21371	0.00293	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	23.1	;
	273	274	0.00201	0.00675	0.00009	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	0.7	;
	273	282	0.00182	0.00803	0.00009	141.9	148.1	148.1	0	0	1	-360	360	0	0	0	0	0	0.9	;
	274	275	0.00281	0.00944	0.00013	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	1.0	;
	275	276	0.02600	0.08734	0.00479	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	18.9	;
	276	277	0.00138	0.00609	0.00007	141.9	148.1	148.1	0	0	1	-360	360	0	0	0	0	0	0.7	;
	277	278	0.00441	0.01480	0.00020	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	1.6	;
	278	279	0.00903	0.03035	0.00166	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	6.6	;
	280	281	0.00538	0.01809	0.00099	126	142.6	142.6	0	0	1	-360	360	0	0	0	0	0	3.9	;
	281	282	0.00356	0.01569	0.00017	141.9	148.1	148.1	0	0	1	-360	360	0	0	0	0	0	1.7	;
	283	284	0.01858	0.08318	0.00442	89.5	127.8	127.8	0	0	1	-360	360	0	0	0	0	0	18.1	;
	284	285	0.00040	0.00134	0.00007	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	0.3	;
	285	286	0.00640	0.02868	0.00152	89.5	127.8	127.8	0	0	1	-360	360	0	0	0	0	0	6.2	;
	287	288	0.00001	0.00008	0.00004	260	273	296	0	0	1	-360	360	0	0	0	0	0	0.1	;
	287	289	0.00080	0.00550	0.00257	260	273	296	0	0	1	-360	360	0	0	0	0	0	3.5	;
	289	290	0.00073	0.00503	0.00235	260	273	296	0	0	1	-360	360	0	0	0	0	0	3.2	;
	290	291	0.00023	0.00158	0.00074	260	273	296	0	0	1	-360	360	0	0	0	0	0	1.0	;
	291	292	0.00003	0.00024	0.00011	260	273	296	0	0	1	-360	360	0	0	0	0	0	0.2	;
	292	293	0.00352	0.00995	0.25805	200	200	200	0	0	1	-360	360	0	0	0	0	0	18.0	;
	294	295	0.05723	0.15326	0.00193	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	15.9	;
	295	296	0.01177	0.03051	0.00039	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	3.3	;
	296	297	0.00413	0.01106	0.00014	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	1.2	;
	298	299	0.00022	0.00074	0.00001	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	0.1	;
	299	300	0.00065	0.00224	0.00307	75.3	93.4	93.4	0	0	1	-360	360	0	0	0	0	0	0.9	;
	299	301	0.04932	0.16570	0.00227	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	17.9	;
	301	302	0.04635	0.15571	0.00213	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	16.8	;
	302	303	0.05326	0.17893	0.00245	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	19.3	;
	303	304	0.00006	0.00019	0.00000	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	0.0	;
	306	307	0.00069	0.00352	0.00131	255	260	260	0	0	1	-360	360	0	0	0	0	0	2.0	;
	310	318	0.00239	0.02618	0.73707	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	130.0	;
	312	305	0.00149	0.01430	0.42682	1280	1386	1386	0	0	1	-360	360	0	0	0	0	0	36.0	;
	313	315	0.00119	0.01340	0.35628	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	65.0	;
	313	316	0.00095	0.01070	0.28447	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	51.9	;
	8	36	0.00068	0.00636	0.00000	250	250	250	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	8	109	0.00164	0.09698	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	9	112	0.00217	0.09340	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	9	112	0.00225	0.09479	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	9	112	0.00233	0.09763	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	9	112	0.00318	0.10011	0.00000	120	120	120	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	10	80	0.00089	0.04787	0.00000	250	250	250	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	10	80	0.00089	0.04771	0.00000	250	250	250	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	10	113	0.00174	0.10334	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	10	113	0.00733	0.16386	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	10	113	0.00232	0.09633	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	11	117	0.00214	0.10048	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	11	117	0.00238	0.09587	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	12	121	0.00190	0.07474	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	12	121	0.00220	0.09913	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	12	121	0.00616	0.16343	0.00000	63	63	63	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	12	121	0.00222	0.10167	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	13	84	0.00042	0.02753	0.00000	450	450	450	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	13	123	0.00311	0.09582	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	13	123	0.00286	0.09329	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	13	123	0.00225	0.09711	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	13	123	0.00236	0.09720	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	14	86	0.00043	0.02838	0.00000	450	450	450	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	14	86	0.00043	0.02841	0.00000	450	450	450	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	15	87	0.00054	0.03452	0.00000	360	360	360	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	15	87	0.00056	0.03403	0.00000	360	360	360	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	15	126	0.00373	0.03262	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	15	126	0.00311	0.09643	0.00000	120	120	120	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	15	126	0.00314	0.09606	0.00000	120	120	120	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	16	47	0.00210	0.08795	0.00000	80	80	80	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	17	88	0.00060	0.04458	0.00000	360	360	360	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	17	88	0.00060	0.04458	0.00000	360	360	360	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	17	128	0.00306	0.09450	0.00000	120	120	120	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	17	128	0.00288	0.09556	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	18	133	0.00176	0.09245	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	18	133	0.00307	0.09449	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	18	133	0.00310	0.09450	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	19	140	0.00667	0.15983	0.00000	63	63	63	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	19	140	0.00846	0.19132	0.00000	63	63	63	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	20	141	0.00175	0.09486	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	20	141	0.00174	0.09564	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	21	142	0.00174	0.10334	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	21	142	0.00175	0.09398	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	22	146	0.00183	0.09857	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	22	146	0.00183	0.09857	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	23	149	0.00219	0.09343	0.00000	126	126	126	0.975000000	0	1	-360	360	0.0042	7	1	25	13	0	;
	23	149	0.00217	0.09495	0.00000	126	126	126	0.975000000	0	1	-360	360	0.0042	7	1	25	13	0	;
	23	149	0.00283	0.09606	0.00000	126	126	126	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	24	98	0.00042	0.04200	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	24	98	0.00042	0.04111	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	24	150	0.00783	0.13894	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	24	150	0.00835	0.18356	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	24	150	0.00783	0.13894	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	25	151	0.00225	0.10061	0.00000	126	126	126	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	25	151	0.00239	0.09656	0.00000	126	126	126	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	25	151	0.00174	0.09398	0.00000	170	170	170	0.975000000	0	1	-360	360	0.0042	7	1	25	13	0	;
	29	102	0.00043	0.03488	0.00000	450	450	450	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	29	159	0.00172	0.09187	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	29	159	0.00185	0.09620	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	31	72	0.00050	0.04040	0.00000	250	250	250	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	31	72	0.00068	0.04048	0.00000	250	250	250	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	31	162	0.00502	0.16181	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	31	162	0.00255	0.09687	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	32	104	0.00042	0.04111	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	32	104	0.00042	0.04111	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	32	108	0.00000	0.11643	0.00000	140	140	140	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	33	163	0.00175	0.09562	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	33	163	0.00169	0.09567	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	34	107	0.00044	0.03478	0.00000	450	450	450	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	34	107	0.00076	0.03467	0.00000	450	450	450	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	34	169	0.00251	0.09728	0.00000	126	126	126	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	34	169	0.00254	0.09799	0.00000	126	126	126	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	36	109	0.00177	0.09261	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	36	109	0.00153	0.09406	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	37	110	0.00172	0.08920	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	37	110	0.00174	0.08968	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	37	110	0.00159	0.10202	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	38	111	0.00185	0.10291	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	38	111	0.00184	0.10291	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	38	111	0.00185	0.10302	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	39	114	0.00189	0.10381	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	39	114	0.00189	0.10381	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	39	114	0.00246	0.09660	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	40	115	0.00308	0.08194	0.00000	120	120	120	1.025000000	0	1	-360	360	0.0042	19	1	25	13	0	;
	40	115	0.00175	0.09833	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	41	81	0.00038	0.03554	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	41	81	0.00035	0.03570	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	41	116	0.00182	0.10291	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	41	116	0.00186	0.10476	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	42	118	0.00226	0.08947	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	42	118	0.00667	0.17937	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	42	118	0.00687	0.18424	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	42	118	0.00260	0.09610	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	43	82	0.00035	0.02646	0.00000	450	450	450	0.975000000	0	1	-360	360	0.0042	7	1	25	13	0	;
	43	82	0.00034	0.03561	0.00000	450	450	450	0.970833333	0	1	-360	360	0.0042	6	1	25	13	0	;
	43	119	0.00159	0.10273	0.00000	170	170	170	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	44	120	0.00159	0.10440	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	44	120	0.00303	0.08938	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	44	120	0.00213	0.09363	0.00000	126	126	126	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	44	120	0.00235	0.09467	0.00000	126	126	126	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	45	85	0.00041	0.02771	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	45	85	0.00042	0.02792	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	45	124	0.00243	0.09735	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	45	124	0.00088	0.02459	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	45	124	0.00206	0.09777	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	46	125	0.00159	0.10729	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	46	125	0.00159	0.10729	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	46	125	0.00159	0.10729	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	47	127	0.00161	0.10741	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	47	127	0.00161	0.10741	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	47	127	0.00161	0.10741	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	48	129	0.00262	0.09303	0.00000	120	120	120	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	48	129	0.00301	0.08939	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	48	129	0.00193	0.10811	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	49	130	0.00222	0.09429	0.00000	120	120	120	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	49	130	0.00248	0.09324	0.00000	120	120	120	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	49	130	0.00261	0.09491	0.00000	120	120	120	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	49	130	0.00230	0.09420	0.00000	126	126	126	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	50	89	0.00035	0.03542	0.00000	450	450	450	0.970833333	0	1	-360	360	0.0042	6	1	25	13	0	;
	50	89	0.00040	0.02611	0.00000	450	450	450	0.975000000	0	1	-360	360	0.0042	7	1	25	13	0	;
	50	89	0.00040	0.02685	0.00000	450	450	450	0.975000000	0	1	-360	360	0.0042	7	1	25	13	0	;
	51	90	0.00035	0.03542	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	52	132	0.00258	0.09514	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	53	134	0.00181	0.10383	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	53	134	0.00220	0.09305	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	53	134	0.00186	0.10429	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	55	135	0.00174	0.07004	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	55	135	0.00313	0.09828	0.00000	120	120	120	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	55	135	0.00318	0.09619	0.00000	120	120	120	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	55	135	0.00148	0.10157	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	56	136	0.00169	0.08935	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	56	136	0.00168	0.08989	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	56	136	0.00172	0.08913	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	57	93	0.00037	0.02604	0.00000	450	450	450	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	57	93	0.00036	0.02624	0.00000	450	450	450	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	57	138	0.00279	0.09137	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	57	138	0.00182	0.10337	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	57	138	0.00088	0.02459	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	58	139	0.00174	0.08924	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	58	139	0.00172	0.08954	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	58	139	0.00167	0.08815	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	59	143	0.00166	0.11001	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	59	143	0.00165	0.11008	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	60	144	0.00186	0.10425	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	60	144	0.00229	0.09421	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	62	152	0.00190	0.09563	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	62	152	0.00238	0.09541	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	62	152	0.00690	0.18513	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	63	153	0.00492	0.18032	0.00000	63	63	63	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	63	153	0.00690	0.18424	0.00000	63	63	63	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	64	154	0.00235	0.09390	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	64	154	0.00208	0.09320	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	65	155	0.00238	0.11984	0.00000	126	126	126	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	65	155	0.00208	0.09683	0.00000	126	126	126	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	65	155	0.00206	0.09841	0.00000	126	126	126	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	66	156	0.00224	0.09526	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	66	156	0.00164	0.09720	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	68	157	0.00185	0.10818	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	68	157	0.00182	0.10768	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	69	101	0.00035	0.03524	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	71	161	0.00224	0.09615	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	71	161	0.00161	0.10130	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	73	165	0.00228	0.09986	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	73	165	0.00207	0.09444	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	74	166	0.00161	0.10116	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	74	166	0.00161	0.10168	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	75	167	0.00188	0.10349	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	75	167	0.00188	0.10349	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	75	167	0.00309	0.08174	0.00000	120	120	120	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	76	168	0.00189	0.10744	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	76	168	0.00186	0.10639	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	76	168	0.00206	0.01435	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	77	106	0.00035	0.03589	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	77	106	0.00035	0.03542	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	77	106	0.00035	0.03598	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	78	170	0.00238	0.09841	0.00000	126	126	126	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	78	170	0.00229	0.09655	0.00000	126	126	126	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	79	172	0.00230	0.09955	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	79	172	0.00236	0.09390	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	81	116	0.00182	0.09659	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	81	116	0.00182	0.09641	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	82	119	0.00149	0.09225	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	82	119	0.00151	0.09331	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	82	119	0.00154	0.09267	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	83	122	0.00149	0.09236	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	83	122	0.00150	0.09173	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	83	122	0.00151	0.09236	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	88	128	0.00203	0.09550	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	88	128	0.00204	0.09549	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	89	131	0.00151	0.09236	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	89	131	0.00151	0.09278	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	89	131	0.00204	0.09549	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	92	137	0.00150	0.09236	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	92	137	0.00154	0.09277	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	94	319	0.00082	0.02035	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	94	319	0.00082	0.02035	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	95	145	0.00082	0.02035	0.00000	170	170	170	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	95	145	0.00155	0.09267	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	95	145	0.00211	0.09517	0.00000	170	170	170	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	97	147	0.00200	0.09776	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	97	147	0.00200	0.09776	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	101	158	0.00151	0.09236	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	101	158	0.00153	0.09299	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	103	160	0.00153	0.09299	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	103	160	0.00151	0.09267	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	105	164	0.00182	0.08988	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	105	164	0.00184	0.09109	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	171	316	0.00082	0.02035	0.00000	170	170	170	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	171	316	0.00082	0.02035	0.00000	170	170	170	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	306	312	0.00076	0.03467	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	309	318	0.00038	0.03554	0.00000	450	450	450	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	313	320	0.00082	0.02035	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	313	320	0.00082	0.02035	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	315	321	0.00082	0.02035	0.00000	170	170	170	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
];
